/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.mango.net;

import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.Range;
import com.google.common.primitives.UnsignedBytes;
import java.math.BigInteger;
import java.net.Inet6Address;
import org.calrissian.mango.net.IP;
import org.calrissian.mango.net.MoreInetAddresses;

public final class IPv6
extends IP<Inet6Address>
implements Comparable<IPv6> {
    private static final DiscreteDomain<IPv6> DISCRETE_DOMAIN = new DiscreteDomain<IPv6>(){
        private final IPv6 MIN_VALUE = IPv6.fromString("::");
        private final IPv6 MAX_VALUE = IPv6.fromString("ffff:ffff:ffff:ffff:ffff:ffff:ffff:ffff");

        public IPv6 next(IPv6 iPv6) {
            return new IPv6(MoreInetAddresses.increment((Inet6Address)iPv6.getAddress()));
        }

        public IPv6 previous(IPv6 iPv6) {
            return new IPv6(MoreInetAddresses.decrement((Inet6Address)iPv6.getAddress()));
        }

        public long distance(IPv6 start, IPv6 end) {
            return 1.bigIntegers().distance((Comparable)new BigInteger(1, start.toByteArray()), (Comparable)new BigInteger(1, end.toByteArray()));
        }

        public IPv6 minValue() {
            return this.MIN_VALUE;
        }

        public IPv6 maxValue() {
            return this.MAX_VALUE;
        }
    };

    public IPv6(Inet6Address address) {
        super(address);
    }

    @Override
    public int compareTo(IPv6 o) {
        if (o == null) {
            return 1;
        }
        return UnsignedBytes.lexicographicalComparator().compare(this.toByteArray(), o.toByteArray());
    }

    public static IPv6 fromString(String addr) {
        return new IPv6(MoreInetAddresses.forIPv6String(addr));
    }

    public static Range<IPv6> cidrRange(String cidr) {
        try {
            MoreInetAddresses.CidrInfo cidrInfo = MoreInetAddresses.parseCIDR(cidr);
            if (cidrInfo.getNetwork() instanceof Inet6Address && cidrInfo.getBroadcast() instanceof Inet6Address) {
                return Range.closed((Comparable)new IPv6((Inet6Address)cidrInfo.getNetwork()), (Comparable)new IPv6((Inet6Address)cidrInfo.getBroadcast()));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new IllegalArgumentException(String.format("Invalid IPv6 cidr representation %s", cidr));
    }

    public static DiscreteDomain<IPv6> discreteDomain() {
        return DISCRETE_DOMAIN;
    }
}

