/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.mango.criteria.domain;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Objects;
import org.calrissian.mango.criteria.domain.Node;
import org.calrissian.mango.criteria.visitor.NodeVisitor;

public abstract class ParentNode
implements Node {
    private static final long serialVersionUID = 1L;
    private final List<Node> nodes;
    private final ParentNode parent;

    public ParentNode(List<Node> nodes, ParentNode parent) {
        this.nodes = (List)Preconditions.checkNotNull(nodes);
        this.parent = parent;
    }

    @Override
    public ParentNode parent() {
        return this.parent;
    }

    @Override
    public List<Node> children() {
        return this.nodes;
    }

    @Override
    public void addChild(Node node) {
        this.nodes.add(node);
    }

    @Override
    public void removeChild(Node node) {
        this.nodes.remove(node);
    }

    public List<Node> getNodes() {
        return this.nodes;
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.begin(this);
        for (Node node : this.nodes.toArray(new Node[this.nodes.size()])) {
            node.accept(visitor);
        }
        visitor.end(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ParentNode that = (ParentNode)o;
        return Objects.equals(this.nodes, that.nodes);
    }

    public int hashCode() {
        return Objects.hash(this.nodes);
    }
}

