/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.mango.criteria.domain.criteria;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.calrissian.mango.criteria.domain.criteria.Criteria;

public abstract class ParentCriteria
implements Criteria {
    private static final long serialVersionUID = 1L;
    private final List<Criteria> nodes;
    private final ParentCriteria parent;

    public ParentCriteria(List<Criteria> nodes, ParentCriteria parent) {
        this.nodes = (List)Preconditions.checkNotNull(nodes);
        this.parent = parent;
    }

    @Override
    public ParentCriteria parent() {
        return this.parent;
    }

    @Override
    public List<Criteria> children() {
        return Collections.unmodifiableList(this.nodes);
    }

    @Override
    public void addChild(Criteria node) {
        this.nodes.add(node);
    }

    @Override
    public void removeChild(Criteria node) {
        this.nodes.remove(node);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ParentCriteria that = (ParentCriteria)o;
        return Objects.equals(this.nodes, that.nodes);
    }

    public int hashCode() {
        return Objects.hash(this.nodes);
    }
}

