/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.mango.net;

import com.google.common.base.Preconditions;
import com.google.common.net.InetAddresses;
import java.io.Serializable;
import java.net.InetAddress;

public abstract class IP<T extends InetAddress>
implements Serializable {
    private static final long serialVersionUID = 2L;
    private final T address;

    protected IP(T address) {
        Preconditions.checkNotNull(address);
        this.address = address;
    }

    public T getAddress() {
        return this.address;
    }

    public byte[] toByteArray() {
        return ((InetAddress)this.address).getAddress();
    }

    public String toString() {
        return InetAddresses.toAddrString(this.address);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IP)) {
            return false;
        }
        IP ip = (IP)o;
        return ((InetAddress)this.address).equals(ip.address);
    }

    public int hashCode() {
        return ((InetAddress)this.address).hashCode();
    }
}

