/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.mango.net;

import com.google.common.base.Preconditions;
import com.google.common.net.InetAddresses;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;

public class MoreInetAddresses {
    private MoreInetAddresses() {
    }

    static InetAddress bytesToInetAddress(byte[] bytes) {
        return bytes.length == 4 ? MoreInetAddresses.getInet4Address(bytes) : MoreInetAddresses.getInet6Address(bytes);
    }

    static Inet4Address getInet4Address(byte[] bytes) {
        Preconditions.checkArgument((bytes.length == 4 ? 1 : 0) != 0, (String)"Byte array has invalid length for an IPv4 address: %s != 4.", (int)bytes.length);
        try {
            return (Inet4Address)InetAddress.getByAddress(bytes);
        }
        catch (UnknownHostException e) {
            throw new AssertionError((Object)e);
        }
    }

    static Inet6Address getInet6Address(byte[] bytes) {
        Preconditions.checkArgument((bytes.length == 16 ? 1 : 0) != 0, (String)"Byte array has invalid length for an IPv4 address: %s != 16.", (int)bytes.length);
        try {
            return Inet6Address.getByAddress(null, bytes, -1);
        }
        catch (UnknownHostException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static InetAddress forString(String ipString) {
        Preconditions.checkNotNull((Object)ipString);
        InetAddress address = InetAddresses.forString((String)ipString);
        if (address instanceof Inet4Address && ipString.contains(":")) {
            return MoreInetAddresses.getIPv4MappedIPv6Address((Inet4Address)address);
        }
        return address;
    }

    public static Inet4Address forIPv4String(String ipString) {
        Preconditions.checkNotNull((Object)ipString);
        try {
            InetAddress parsed = MoreInetAddresses.forString(ipString);
            if (parsed instanceof Inet4Address) {
                return (Inet4Address)parsed;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new IllegalArgumentException(String.format("Invalid IPv4 representation: %s", ipString));
    }

    public static Inet6Address forIPv6String(String ipString) {
        Preconditions.checkNotNull((Object)ipString);
        try {
            InetAddress parsed = MoreInetAddresses.forString(ipString);
            if (parsed instanceof Inet6Address) {
                return (Inet6Address)parsed;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new IllegalArgumentException(String.format("Invalid IPv6 representation: %s", ipString));
    }

    public static boolean isMappedIPv4Address(Inet6Address ip) {
        byte[] bytes = ip.getAddress();
        return bytes[0] == 0 && bytes[1] == 0 && bytes[2] == 0 && bytes[3] == 0 && bytes[4] == 0 && bytes[5] == 0 && bytes[6] == 0 && bytes[7] == 0 && bytes[8] == 0 && bytes[9] == 0 && bytes[10] == -1 && bytes[11] == -1;
    }

    public static Inet4Address getMappedIPv4Address(Inet6Address ip) {
        Preconditions.checkArgument((boolean)MoreInetAddresses.isMappedIPv4Address(ip), (String)"Address '%s' is not IPv4-mapped.", (Object)InetAddresses.toAddrString((InetAddress)ip));
        return MoreInetAddresses.getInet4Address(Arrays.copyOfRange(ip.getAddress(), 12, 16));
    }

    public static boolean hasEmbeddedIPv4ClientAddress(Inet6Address ip) {
        return MoreInetAddresses.isMappedIPv4Address(ip) || InetAddresses.hasEmbeddedIPv4ClientAddress((Inet6Address)ip);
    }

    public static Inet4Address getEmbeddedIPv4ClientAddress(Inet6Address ip) {
        if (MoreInetAddresses.isMappedIPv4Address(ip)) {
            return MoreInetAddresses.getMappedIPv4Address(ip);
        }
        return InetAddresses.getEmbeddedIPv4ClientAddress((Inet6Address)ip);
    }

    public static Inet6Address getIPv4MappedIPv6Address(Inet4Address ip) {
        byte[] from = ip.getAddress();
        byte[] bytes = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1, from[0], from[1], from[2], from[3]};
        return MoreInetAddresses.getInet6Address(bytes);
    }

    public static Inet6Address getIPV4CompatIPv6Address(Inet4Address ip) {
        byte[] from = ip.getAddress();
        byte[] bytes = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, from[0], from[1], from[2], from[3]};
        return MoreInetAddresses.getInet6Address(bytes);
    }

    private static byte[] incrementBytes(InetAddress address) {
        int i;
        byte[] addr = address.getAddress();
        for (i = addr.length - 1; i >= 0 && addr[i] == -1; --i) {
            addr[i] = 0;
        }
        Preconditions.checkArgument((i >= 0 ? 1 : 0) != 0, (String)"Incrementing %s would wrap.", (Object)address);
        int n = i;
        addr[n] = (byte)(addr[n] + 1);
        return addr;
    }

    public static Inet4Address increment(Inet4Address ip) {
        return MoreInetAddresses.getInet4Address(MoreInetAddresses.incrementBytes(ip));
    }

    public static Inet6Address increment(Inet6Address ip) {
        return MoreInetAddresses.getInet6Address(MoreInetAddresses.incrementBytes(ip));
    }

    private static byte[] decrementBytes(InetAddress address) {
        int i;
        byte[] addr = address.getAddress();
        for (i = addr.length - 1; i >= 0 && addr[i] == 0; --i) {
            addr[i] = -1;
        }
        Preconditions.checkArgument((i >= 0 ? 1 : 0) != 0, (String)"Decrementing %s would wrap.", (Object)address);
        int n = i;
        addr[n] = (byte)(addr[n] - 1);
        return addr;
    }

    public static Inet4Address decrement(Inet4Address ip) {
        return MoreInetAddresses.getInet4Address(MoreInetAddresses.decrementBytes(ip));
    }

    public static Inet6Address decrement(Inet6Address ip) {
        return MoreInetAddresses.getInet6Address(MoreInetAddresses.decrementBytes(ip));
    }

    public static CidrInfo parseCIDR(String cidr) {
        Preconditions.checkNotNull((Object)cidr);
        try {
            String[] parts = cidr.split("/");
            Preconditions.checkArgument((parts.length == 2 ? 1 : 0) != 0);
            byte[] bytes = MoreInetAddresses.forString(parts[0]).getAddress();
            int maskBits = Integer.parseInt(parts[1]);
            Preconditions.checkArgument((maskBits >= 0 && maskBits <= bytes.length * 8 ? 1 : 0) != 0);
            int remainingBits = maskBits;
            byte[] network = new byte[bytes.length];
            byte[] broadcast = new byte[bytes.length];
            for (int i = 0; i < bytes.length; ++i) {
                if (remainingBits >= 8) {
                    network[i] = bytes[i];
                    broadcast[i] = bytes[i];
                } else if (remainingBits > 0) {
                    int byteMask = -1 << 8 - remainingBits;
                    network[i] = (byte)(bytes[i] & byteMask);
                    broadcast[i] = (byte)(bytes[i] | ~byteMask);
                } else {
                    network[i] = 0;
                    broadcast[i] = -1;
                }
                remainingBits -= 8;
            }
            return new CidrInfo(maskBits, MoreInetAddresses.bytesToInetAddress(network), MoreInetAddresses.bytesToInetAddress(broadcast));
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(String.format("Invalid CIDR string: %s", cidr));
        }
    }

    public static class CidrInfo {
        private final int maskedBits;
        private final InetAddress network;
        private final InetAddress broadcast;

        CidrInfo(int maskedBits, InetAddress network, InetAddress broadcast) {
            this.maskedBits = maskedBits;
            this.network = network;
            this.broadcast = broadcast;
        }

        public InetAddress getNetwork() {
            return this.network;
        }

        public InetAddress getBroadcast() {
            return this.broadcast;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CidrInfo cidrInfo = (CidrInfo)o;
            if (this.maskedBits != cidrInfo.maskedBits) {
                return false;
            }
            if (!this.broadcast.equals(cidrInfo.broadcast)) {
                return false;
            }
            return this.network.equals(cidrInfo.network);
        }

        public int hashCode() {
            int result = this.maskedBits;
            result = 31 * result + this.network.hashCode();
            result = 31 * result + this.broadcast.hashCode();
            return result;
        }

        public String toString() {
            return InetAddresses.toAddrString((InetAddress)this.network) + "/" + this.maskedBits;
        }
    }
}

