/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.mango.domain.entity;

import com.google.common.base.Preconditions;
import org.calrissian.mango.domain.AbstractAttributeStore;
import org.calrissian.mango.domain.Attribute;
import org.calrissian.mango.domain.entity.Entity;
import org.calrissian.mango.domain.entity.EntityIdentifier;

public class BaseEntity
extends AbstractAttributeStore
implements Entity {
    private static final long serialVersionUID = 1L;
    private final EntityIdentifier identifier;

    public BaseEntity(EntityIdentifier identifier, Iterable<? extends Attribute> attributes) {
        super(attributes);
        this.identifier = (EntityIdentifier)Preconditions.checkNotNull((Object)identifier);
    }

    public BaseEntity(Entity entity) {
        this(entity.getIdentifier(), entity.getAttributes());
    }

    @Override
    public String getId() {
        return this.identifier.getId();
    }

    @Override
    public String getType() {
        return this.identifier.getType();
    }

    @Override
    public EntityIdentifier getIdentifier() {
        return this.identifier;
    }

    public String toString() {
        return "BaseEntity{id='" + this.getId() + '\'' + ", type='" + this.getType() + '\'' + ", attributes='" + this.getAttributes() + '\'' + '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BaseEntity that = (BaseEntity)o;
        return this.identifier.equals(that.identifier);
    }

    @Override
    public int hashCode() {
        return this.identifier.hashCode();
    }
}

