/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.mango.domain.entity;

import com.google.common.base.Preconditions;
import org.calrissian.mango.domain.AbstractAttributeStoreBuilder;
import org.calrissian.mango.domain.entity.BaseEntity;
import org.calrissian.mango.domain.entity.Entity;
import org.calrissian.mango.domain.entity.EntityIdentifier;

public class EntityBuilder
extends AbstractAttributeStoreBuilder<Entity, EntityBuilder> {
    private final EntityIdentifier identifier;

    public static EntityBuilder create(EntityIdentifier identifier) {
        Preconditions.checkNotNull((Object)identifier);
        return new EntityBuilder(identifier);
    }

    public static EntityBuilder create(String type, String id) {
        return EntityBuilder.create(new EntityIdentifier(type, id));
    }

    public static EntityBuilder create(Entity entity) {
        return (EntityBuilder)EntityBuilder.create(entity.getIdentifier()).attrs(entity.getAttributes());
    }

    protected EntityBuilder(EntityIdentifier identifier) {
        this.identifier = identifier;
    }

    @Override
    public Entity build() {
        return new BaseEntity(this.identifier, this.attributes);
    }
}

