/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.mango.domain.event;

import com.google.common.base.Preconditions;
import org.calrissian.mango.domain.AbstractAttributeStoreBuilder;
import org.calrissian.mango.domain.Attribute;
import org.calrissian.mango.domain.event.BaseEvent;
import org.calrissian.mango.domain.event.Event;
import org.calrissian.mango.domain.event.EventIdentifier;

public class EventBuilder
extends AbstractAttributeStoreBuilder<Event, EventBuilder> {
    private final EventIdentifier identifier;

    public static EventBuilder create(EventIdentifier identifier) {
        Preconditions.checkNotNull((Object)identifier);
        return new EventBuilder(identifier);
    }

    public static EventBuilder create(String type, String id, long timestamp) {
        return EventBuilder.create(new EventIdentifier(type, id, timestamp));
    }

    public static EventBuilder create(Event event) {
        return (EventBuilder)EventBuilder.create(event.getIdentifier()).attrs(event.getAttributes());
    }

    protected EventBuilder(EventIdentifier identifier) {
        this.identifier = identifier;
    }

    @Override
    public Event build() {
        return new BaseEvent(this.identifier, (Iterable<? extends Attribute>)this.attributes);
    }
}

