/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.mango.types;

import com.google.common.primitives.UnsignedInteger;
import com.google.common.primitives.UnsignedLong;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.URI;
import java.util.Date;
import org.calrissian.mango.domain.entity.EntityIdentifier;
import org.calrissian.mango.domain.event.EventIdentifier;
import org.calrissian.mango.net.IPv4;
import org.calrissian.mango.net.IPv6;
import org.calrissian.mango.types.SimpleTypeEncoders;
import org.calrissian.mango.types.TypeEncoder;
import org.calrissian.mango.types.TypeRegistry;
import org.calrissian.mango.types.encoders.lexi.BigDecimalEncoder;
import org.calrissian.mango.types.encoders.lexi.BigDecimalReverseEncoder;
import org.calrissian.mango.types.encoders.lexi.BigIntegerEncoder;
import org.calrissian.mango.types.encoders.lexi.BigIntegerReverseEncoder;
import org.calrissian.mango.types.encoders.lexi.BooleanEncoder;
import org.calrissian.mango.types.encoders.lexi.BooleanReverseEncoder;
import org.calrissian.mango.types.encoders.lexi.ByteEncoder;
import org.calrissian.mango.types.encoders.lexi.ByteReverseEncoder;
import org.calrissian.mango.types.encoders.lexi.DateEncoder;
import org.calrissian.mango.types.encoders.lexi.DateReverseEncoder;
import org.calrissian.mango.types.encoders.lexi.DoubleEncoder;
import org.calrissian.mango.types.encoders.lexi.DoubleReverseEncoder;
import org.calrissian.mango.types.encoders.lexi.EventIdentifierEncoder;
import org.calrissian.mango.types.encoders.lexi.FloatEncoder;
import org.calrissian.mango.types.encoders.lexi.FloatReverseEncoder;
import org.calrissian.mango.types.encoders.lexi.IPv4Encoder;
import org.calrissian.mango.types.encoders.lexi.IPv4ReverseEncoder;
import org.calrissian.mango.types.encoders.lexi.IPv6Encoder;
import org.calrissian.mango.types.encoders.lexi.IPv6ReverseEncoder;
import org.calrissian.mango.types.encoders.lexi.Inet4AddressEncoder;
import org.calrissian.mango.types.encoders.lexi.Inet4AddressReverseEncoder;
import org.calrissian.mango.types.encoders.lexi.Inet6AddressEncoder;
import org.calrissian.mango.types.encoders.lexi.Inet6AddressReverseEncoder;
import org.calrissian.mango.types.encoders.lexi.IntegerEncoder;
import org.calrissian.mango.types.encoders.lexi.IntegerReverseEncoder;
import org.calrissian.mango.types.encoders.lexi.LongEncoder;
import org.calrissian.mango.types.encoders.lexi.LongReverseEncoder;
import org.calrissian.mango.types.encoders.lexi.ReverseEncoder;
import org.calrissian.mango.types.encoders.lexi.UnsignedIntegerEncoder;
import org.calrissian.mango.types.encoders.lexi.UnsignedIntegerReverseEncoder;
import org.calrissian.mango.types.encoders.lexi.UnsignedLongEncoder;
import org.calrissian.mango.types.encoders.lexi.UnsignedLongReverseEncoder;

public class LexiTypeEncoders {
    public static final TypeRegistry<String> LEXI_JAVA_TYPES = new TypeRegistry(LexiTypeEncoders.booleanEncoder(), LexiTypeEncoders.byteEncoder(), LexiTypeEncoders.dateEncoder(), LexiTypeEncoders.doubleEncoder(), LexiTypeEncoders.floatEncoder(), LexiTypeEncoders.integerEncoder(), LexiTypeEncoders.longEncoder(), LexiTypeEncoders.stringEncoder(), LexiTypeEncoders.uriEncoder(), LexiTypeEncoders.bigIntegerEncoder(), LexiTypeEncoders.bigDecimalEncoder(), LexiTypeEncoders.inet4AddressEncoder(), LexiTypeEncoders.inet6AddressEncoder());
    public static final TypeRegistry<String> LEXI_REV_JAVA_TYPES = new TypeRegistry(LexiTypeEncoders.booleanRevEncoder(), LexiTypeEncoders.byteRevEncoder(), LexiTypeEncoders.dateRevEncoder(), LexiTypeEncoders.doubleRevEncoder(), LexiTypeEncoders.floatRevEncoder(), LexiTypeEncoders.integerRevEncoder(), LexiTypeEncoders.longRevEncoder(), LexiTypeEncoders.stringRevEncoder(), LexiTypeEncoders.uriRevEncoder(), LexiTypeEncoders.bigIntegerRevEncoder(), LexiTypeEncoders.bigDecimalRevEncoder(), LexiTypeEncoders.inet4AddressRevEncoder(), LexiTypeEncoders.inet6AddressRevEncoder());
    public static final TypeRegistry<String> LEXI_TYPES = new TypeRegistry<String>(LEXI_JAVA_TYPES, LexiTypeEncoders.ipv4Encoder(), LexiTypeEncoders.ipv6Encoder(), LexiTypeEncoders.entityIdentifierEncoder(), LexiTypeEncoders.eventIdentifierEncoder(), LexiTypeEncoders.unsignedIntegerEncoder(), LexiTypeEncoders.unsignedLongEncoder());
    public static final TypeRegistry<String> LEXI_REV_TYPES = new TypeRegistry<String>(LEXI_REV_JAVA_TYPES, LexiTypeEncoders.ipv4RevEncoder(), LexiTypeEncoders.ipv6RevEncoder(), LexiTypeEncoders.entityIdentifierRevEncoder(), LexiTypeEncoders.eventIdentifierRevEncoder(), LexiTypeEncoders.unsignedIntegerRevEncoder(), LexiTypeEncoders.unsignedLongRevEncoder());

    private LexiTypeEncoders() {
    }

    private static <T> TypeEncoder<T, String> reverseEncoder(TypeEncoder<T, String> sourceEncoder) {
        return new ReverseEncoder<T>(sourceEncoder);
    }

    public static TypeEncoder<Boolean, String> booleanEncoder() {
        return new BooleanEncoder();
    }

    public static TypeEncoder<Boolean, String> booleanRevEncoder() {
        return new BooleanReverseEncoder();
    }

    public static TypeEncoder<Byte, String> byteEncoder() {
        return new ByteEncoder();
    }

    public static TypeEncoder<Byte, String> byteRevEncoder() {
        return new ByteReverseEncoder();
    }

    public static TypeEncoder<Date, String> dateEncoder() {
        return new DateEncoder();
    }

    public static TypeEncoder<Date, String> dateRevEncoder() {
        return new DateReverseEncoder();
    }

    public static TypeEncoder<Double, String> doubleEncoder() {
        return new DoubleEncoder();
    }

    public static TypeEncoder<Double, String> doubleRevEncoder() {
        return new DoubleReverseEncoder();
    }

    public static TypeEncoder<Float, String> floatEncoder() {
        return new FloatEncoder();
    }

    public static TypeEncoder<Float, String> floatRevEncoder() {
        return new FloatReverseEncoder();
    }

    public static TypeEncoder<Integer, String> integerEncoder() {
        return new IntegerEncoder();
    }

    public static TypeEncoder<Integer, String> integerRevEncoder() {
        return new IntegerReverseEncoder();
    }

    public static TypeEncoder<Long, String> longEncoder() {
        return new LongEncoder();
    }

    public static TypeEncoder<Long, String> longRevEncoder() {
        return new LongReverseEncoder();
    }

    public static TypeEncoder<String, String> stringEncoder() {
        return SimpleTypeEncoders.stringEncoder();
    }

    public static TypeEncoder<String, String> stringRevEncoder() {
        return LexiTypeEncoders.reverseEncoder(LexiTypeEncoders.stringEncoder());
    }

    public static TypeEncoder<URI, String> uriEncoder() {
        return SimpleTypeEncoders.uriEncoder();
    }

    public static TypeEncoder<URI, String> uriRevEncoder() {
        return LexiTypeEncoders.reverseEncoder(LexiTypeEncoders.uriEncoder());
    }

    public static TypeEncoder<BigInteger, String> bigIntegerEncoder() {
        return new BigIntegerEncoder();
    }

    public static TypeEncoder<BigInteger, String> bigIntegerRevEncoder() {
        return new BigIntegerReverseEncoder();
    }

    public static TypeEncoder<BigDecimal, String> bigDecimalEncoder() {
        return new BigDecimalEncoder();
    }

    public static TypeEncoder<BigDecimal, String> bigDecimalRevEncoder() {
        return new BigDecimalReverseEncoder();
    }

    public static TypeEncoder<Inet4Address, String> inet4AddressEncoder() {
        return new Inet4AddressEncoder();
    }

    public static TypeEncoder<Inet4Address, String> inet4AddressRevEncoder() {
        return new Inet4AddressReverseEncoder();
    }

    public static TypeEncoder<Inet6Address, String> inet6AddressEncoder() {
        return new Inet6AddressEncoder();
    }

    public static TypeEncoder<Inet6Address, String> inet6AddressRevEncoder() {
        return new Inet6AddressReverseEncoder();
    }

    public static TypeEncoder<IPv4, String> ipv4Encoder() {
        return new IPv4Encoder();
    }

    public static TypeEncoder<IPv4, String> ipv4RevEncoder() {
        return new IPv4ReverseEncoder();
    }

    public static TypeEncoder<IPv6, String> ipv6Encoder() {
        return new IPv6Encoder();
    }

    public static TypeEncoder<IPv6, String> ipv6RevEncoder() {
        return new IPv6ReverseEncoder();
    }

    public static TypeEncoder<EntityIdentifier, String> entityIdentifierEncoder() {
        return SimpleTypeEncoders.entityIdentifierEncoder();
    }

    public static TypeEncoder<EntityIdentifier, String> entityIdentifierRevEncoder() {
        return LexiTypeEncoders.reverseEncoder(SimpleTypeEncoders.entityIdentifierEncoder());
    }

    public static TypeEncoder<EventIdentifier, String> eventIdentifierEncoder() {
        return new EventIdentifierEncoder();
    }

    public static TypeEncoder<EventIdentifier, String> eventIdentifierRevEncoder() {
        return LexiTypeEncoders.reverseEncoder(LexiTypeEncoders.eventIdentifierEncoder());
    }

    public static TypeEncoder<UnsignedInteger, String> unsignedIntegerEncoder() {
        return new UnsignedIntegerEncoder();
    }

    public static TypeEncoder<UnsignedInteger, String> unsignedIntegerRevEncoder() {
        return new UnsignedIntegerReverseEncoder();
    }

    public static TypeEncoder<UnsignedLong, String> unsignedLongEncoder() {
        return new UnsignedLongEncoder();
    }

    public static TypeEncoder<UnsignedLong, String> unsignedLongRevEncoder() {
        return new UnsignedLongReverseEncoder();
    }
}

