/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.mango.types.encoders.lexi;

import com.google.common.base.Preconditions;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import org.calrissian.mango.types.encoders.AbstractBigDecimalEncoder;
import org.calrissian.mango.types.encoders.lexi.IntegerEncoder;

public class BigDecimalEncoder
extends AbstractBigDecimalEncoder<String> {
    private static final long serialVersionUID = 1L;
    private static final IntegerEncoder intEncoder = new IntegerEncoder();

    private static String tensComplement(String digitStr) {
        int i;
        byte[] digits = digitStr.getBytes(StandardCharsets.UTF_8);
        byte[] comp = new byte[digits.length];
        for (i = 0; i < digits.length; ++i) {
            comp[i] = (byte)(9 - (digits[i] & 0xF) ^ 0x30);
        }
        for (i = comp.length - 1; i >= 0; --i) {
            int n = i;
            comp[n] = (byte)(comp[n] + 1);
            if (comp[i] != 58) break;
            comp[i] = 48;
        }
        return new String(comp, StandardCharsets.UTF_8);
    }

    private static boolean isZeroEnc(String value) {
        for (int i = 0; i < value.length(); ++i) {
            if (value.charAt(i) == '0') continue;
            return false;
        }
        return true;
    }

    @Override
    public String encode(BigDecimal value) {
        String mantissa;
        Preconditions.checkNotNull((Object)value, (Object)"Null values are not allowed");
        int exp = value.precision() - value.scale() - 1;
        if (value.signum() == 0) {
            mantissa = new String(new char[1 - exp]).replace('\u0000', '0');
            exp = Integer.MIN_VALUE;
        } else if (value.signum() < 0) {
            mantissa = BigDecimalEncoder.tensComplement(value.unscaledValue().negate().toString());
            exp = -exp;
        } else {
            mantissa = value.unscaledValue().toString();
        }
        return (value.signum() < 0 ? "0" : "1") + intEncoder.encode(exp) + mantissa;
    }

    @Override
    public BigDecimal decode(String value) {
        BigInteger unscaled;
        Preconditions.checkNotNull((Object)value, (Object)"Null values are not allowed");
        Preconditions.checkArgument((value.length() > 9 ? 1 : 0) != 0, (Object)"The value is not a valid encoding");
        int exp = intEncoder.decode(value.substring(1, 9));
        String mantissa = value.substring(9);
        if (value.charAt(0) == '0') {
            exp = -exp;
            unscaled = new BigInteger(BigDecimalEncoder.tensComplement(mantissa)).negate();
        } else {
            if (BigDecimalEncoder.isZeroEnc(mantissa)) {
                exp = 0;
            }
            unscaled = new BigInteger(mantissa);
        }
        return new BigDecimal(unscaled, mantissa.length() - exp - 1);
    }
}

