/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.mango.types.encoders.simple;

import com.google.common.base.Preconditions;
import org.calrissian.mango.domain.entity.EntityIdentifier;
import org.calrissian.mango.types.encoders.AbstractEntityIdentifierEncoder;
import org.calrissian.mango.types.exception.TypeDecodingException;
import org.calrissian.mango.types.exception.TypeEncodingException;

public class EntityIdentifierEncoder
extends AbstractEntityIdentifierEncoder<String> {
    private static final long serialVersionUID = 1L;
    private static final String SCHEME = "entity://";

    @Override
    public String encode(EntityIdentifier value) throws TypeEncodingException {
        Preconditions.checkNotNull((Object)value, (Object)"Null values are not allowed");
        return String.format("%s%s#%s", SCHEME, value.getType(), value.getId());
    }

    @Override
    public EntityIdentifier decode(String value) throws TypeDecodingException {
        Preconditions.checkNotNull((Object)value, (Object)"Null values are not allowed");
        Preconditions.checkArgument((value.startsWith(SCHEME) && value.contains("#") ? 1 : 0) != 0, (Object)"The value is not a valid encoding");
        String rel = value.substring(SCHEME.length(), value.length());
        int idx = rel.indexOf(35);
        return new EntityIdentifier(rel.substring(0, idx), rel.substring(idx + 1));
    }
}

