/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.mango.batch;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.calrissian.mango.batch.BatchListener;
import org.calrissian.mango.batch.Batcher;

abstract class AbstractBatcher<T>
implements Batcher<T> {
    private static final Logger logger = Logger.getLogger(AbstractBatcher.class.getName());
    private final ExecutorService batchService;
    private final BlockingQueue<T> backingQueue;
    private final BatchListener<T> listener;
    private final ExecutorService handler;
    private volatile boolean isClosed = false;

    AbstractBatcher(BlockingQueue<T> backingQueue, BatchListener<T> listener, ExecutorService handler) {
        this.backingQueue = backingQueue;
        this.listener = listener;
        this.handler = handler;
        this.batchService = Executors.newSingleThreadExecutor();
    }

    protected abstract Collection<T> generateBatch(BlockingQueue<T> var1) throws InterruptedException;

    protected AbstractBatcher<T> start() {
        this.batchService.submit(new BatchRunnable());
        return this;
    }

    @Override
    public final boolean add(T item) {
        Objects.requireNonNull(item);
        Preconditions.checkState((!this.isClosed ? 1 : 0) != 0, (Object)"The batcher has been closed");
        return this.backingQueue.offer(item);
    }

    @Override
    public final boolean add(T item, long timeout, TimeUnit unit) throws InterruptedException {
        Objects.requireNonNull(item);
        Objects.requireNonNull(unit);
        Preconditions.checkState((!this.isClosed ? 1 : 0) != 0, (Object)"The batcher has been closed");
        return this.backingQueue.offer(item, timeout, unit);
    }

    @Override
    public final boolean addOrWait(T item) throws InterruptedException {
        Objects.requireNonNull(item);
        Preconditions.checkState((!this.isClosed ? 1 : 0) != 0, (Object)"The batcher has been closed");
        this.backingQueue.put(item);
        return true;
    }

    private void stopRunnable() {
        this.isClosed = true;
        this.batchService.shutdownNow();
    }

    @Override
    public void close() {
        this.stopRunnable();
        try {
            this.batchService.awaitTermination(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        this.handler.shutdown();
        try {
            this.handler.awaitTermination(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<T> closeAndFlush() {
        this.close();
        ArrayList remaining = new ArrayList();
        this.backingQueue.drainTo(remaining);
        return remaining;
    }

    private class BatchRunnable
    implements Runnable {
        private BatchRunnable() {
        }

        @Override
        public void run() {
            block6: while (true) {
                try {
                    while (!(AbstractBatcher.this.isClosed || AbstractBatcher.this.handler.isShutdown() || Thread.interrupted())) {
                        Collection batch = AbstractBatcher.this.generateBatch(AbstractBatcher.this.backingQueue);
                        if (batch.isEmpty() || AbstractBatcher.this.handler.isShutdown()) continue;
                        try {
                            AbstractBatcher.this.handler.execute(() -> AbstractBatcher.this.listener.onBatch(Collections.unmodifiableCollection(batch)));
                            continue block6;
                        }
                        catch (Exception e) {
                            logger.log(Level.SEVERE, "Encountered exception sending to batch listener.  Stopping the batcher", e);
                            AbstractBatcher.this.stopRunnable();
                        }
                    }
                    break;
                }
                catch (Throwable e) {
                    try {
                        logger.log(Level.SEVERE, "Batcher should not have throw exception.  Stopping the batcher", e);
                        AbstractBatcher.this.stopRunnable();
                        break;
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                        break;
                    }
                }
            }
        }
    }
}

