/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.mango.batch;

import com.google.common.base.Preconditions;
import java.util.AbstractQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.calrissian.mango.batch.AbstractBatcher;
import org.calrissian.mango.batch.BatchListener;
import org.calrissian.mango.batch.Batcher;

public final class BatcherBuilder {
    private static final int UNSET_INT = -1;
    private int maxSize = -1;
    private long interval = -1L;
    private int maxBufferSize = -1;
    private ExecutorService listenerService = null;

    public static BatcherBuilder create() {
        return new BatcherBuilder();
    }

    private BatcherBuilder() {
    }

    public BatcherBuilder sizeBound(int size) {
        Preconditions.checkState((this.maxSize == -1 ? 1 : 0) != 0, (String)"Max size already set to %s", (int)this.maxSize);
        Preconditions.checkArgument((size > 0 ? 1 : 0) != 0, (Object)"Required to have a size bound greater than 0");
        this.maxSize = size;
        return this;
    }

    public BatcherBuilder timeBound(long time, TimeUnit timeUnit) {
        Preconditions.checkState((this.interval == -1L ? 1 : 0) != 0, (Object)"Max time already set");
        Preconditions.checkArgument((time > 0L ? 1 : 0) != 0, (Object)"Required to have a time interval greater than 0");
        Objects.requireNonNull(timeUnit);
        this.interval = timeUnit.toNanos(time);
        return this;
    }

    public BatcherBuilder bufferSize(int bufferSize) {
        Preconditions.checkState((this.maxBufferSize == -1 ? 1 : 0) != 0, (String)"Max buffer size already set to %d", (int)this.maxBufferSize);
        Preconditions.checkArgument((bufferSize > 0 ? 1 : 0) != 0, (Object)"Required to have a buffer size greater than 0");
        this.maxBufferSize = bufferSize;
        return this;
    }

    public BatcherBuilder listenerService(ExecutorService listenerService) {
        Preconditions.checkState((this.listenerService == null ? 1 : 0) != 0, (Object)"A listener service has already been set");
        Objects.requireNonNull(listenerService);
        this.listenerService = listenerService;
        return this;
    }

    public <T> Batcher<T> build(BatchListener<T> listener) {
        AbstractQueue backingQueue;
        Objects.requireNonNull(listener);
        Preconditions.checkState((this.maxSize != -1 || this.interval != -1L ? 1 : 0) != 0, (Object)"All batchers are required to have either a time or size bound.");
        ExecutorService handler = this.listenerService == null ? Executors.newCachedThreadPool() : this.listenerService;
        AbstractQueue abstractQueue = backingQueue = this.maxBufferSize == -1 ? new LinkedBlockingQueue() : new ArrayBlockingQueue(this.maxBufferSize);
        if (this.maxSize != -1 && this.interval != -1L) {
            return new TimeOrSizeBatcher(backingQueue, listener, handler, this.maxSize, this.interval).start();
        }
        if (this.maxSize != -1) {
            return new SizeBatcher(backingQueue, listener, handler, this.maxSize).start();
        }
        return new TimeBatcher(backingQueue, listener, handler, this.interval).start();
    }

    private static final class TimeOrSizeBatcher<T>
    extends AbstractBatcher<T> {
        private final int maxSize;
        private final long interval;

        TimeOrSizeBatcher(BlockingQueue<T> backingQueue, BatchListener<T> listener, ExecutorService handler, int maxSize, long interval) {
            super(backingQueue, listener, handler);
            this.maxSize = maxSize;
            this.interval = interval;
        }

        @Override
        protected Collection<T> generateBatch(BlockingQueue<T> backingQueue) throws InterruptedException {
            ArrayList<T> batch = new ArrayList<T>(this.maxSize);
            try {
                long startTime = System.nanoTime();
                long remainingTime = this.interval;
                int remainingSize = this.maxSize;
                while (remainingSize > 0 && remainingTime > 0L) {
                    if (backingQueue.drainTo(batch, remainingSize) != remainingSize) {
                        T item = backingQueue.poll(remainingTime, TimeUnit.NANOSECONDS);
                        if (item == null) break;
                        batch.add(item);
                    }
                    remainingTime = this.interval - (System.nanoTime() - startTime);
                    remainingSize = this.maxSize - batch.size();
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            return batch;
        }
    }

    private static final class TimeBatcher<T>
    extends AbstractBatcher<T> {
        private final long interval;

        TimeBatcher(BlockingQueue<T> backingQueue, BatchListener<T> listener, ExecutorService handler, long interval) {
            super(backingQueue, listener, handler);
            this.interval = interval;
        }

        @Override
        protected Collection<T> generateBatch(BlockingQueue<T> backingQueue) throws InterruptedException {
            ArrayList<T> batch = new ArrayList<T>();
            try {
                long startTime = System.nanoTime();
                long remainingTime = this.interval;
                while (remainingTime > 0L) {
                    if (backingQueue.drainTo(batch) == 0) {
                        T item = backingQueue.poll(remainingTime, TimeUnit.NANOSECONDS);
                        if (item == null) break;
                        batch.add(item);
                    }
                    remainingTime = this.interval - (System.nanoTime() - startTime);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            return batch;
        }
    }

    private static final class SizeBatcher<T>
    extends AbstractBatcher<T> {
        private final int maxSize;

        SizeBatcher(BlockingQueue<T> backingQueue, BatchListener<T> listener, ExecutorService handler, int maxSize) {
            super(backingQueue, listener, handler);
            this.maxSize = maxSize;
        }

        @Override
        protected Collection<T> generateBatch(BlockingQueue<T> backingQueue) throws InterruptedException {
            ArrayList<T> batch = new ArrayList<T>(this.maxSize);
            try {
                int remainingSize = this.maxSize;
                while (remainingSize > 0) {
                    if (backingQueue.drainTo(batch, remainingSize) != remainingSize) {
                        batch.add(backingQueue.take());
                    }
                    remainingSize = this.maxSize - batch.size();
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            return batch;
        }
    }
}

