/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.mango.collect;

import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.calrissian.mango.collect.CloseableIterable;
import org.calrissian.mango.collect.CloseableIterators;
import org.calrissian.mango.collect.FluentCloseableIterable;
import org.calrissian.mango.collect.Iterables2;

public class CloseableIterables {
    private static final CloseableIterable EMPTY_ITERABLE = new CloseableIterable(){

        @Override
        public void close() {
        }

        @Override
        public Iterator iterator() {
            return Collections.emptyIterator();
        }
    };

    private CloseableIterables() {
    }

    public static <T> CloseableIterable<T> fromStream(Stream<T> stream) {
        return CloseableIterables.wrap(stream::iterator, stream);
    }

    public static <T> CloseableIterable<T> fromIterable(final Iterable<T> iterable) {
        Objects.requireNonNull(iterable);
        if (iterable instanceof CloseableIterable) {
            return (CloseableIterable)iterable;
        }
        return new FluentCloseableIterable<T>(){

            @Override
            protected void doClose() {
                if (iterable instanceof AutoCloseable) {
                    try {
                        ((AutoCloseable)((Object)iterable)).close();
                    }
                    catch (RuntimeException re) {
                        throw re;
                    }
                    catch (Exception e) {
                        throw new IllegalStateException(e);
                    }
                }
            }

            @Override
            protected Iterator<T> retrieveIterator() {
                return iterable.iterator();
            }
        };
    }

    public static <T> CloseableIterable<T> distinct(CloseableIterable<T> iterable) {
        return CloseableIterables.wrap(Iterables2.distinct(iterable), iterable);
    }

    public static <T> CloseableIterable<List<T>> groupBy(CloseableIterable<? extends T> iterable, Function<? super T, ?> groupingFunction) {
        return CloseableIterables.wrap(Iterables2.groupBy(iterable, groupingFunction), iterable);
    }

    public static <T> CloseableIterable<T> concat(CloseableIterable<? extends Iterable<? extends T>> inputs) {
        return CloseableIterables.wrap(Iterables.concat(inputs), inputs);
    }

    public static <T> CloseableIterable<T> cycle(CloseableIterable<T> iterable) {
        return CloseableIterables.wrap(Iterables.cycle(iterable), iterable);
    }

    public static <T> CloseableIterable<T> filter(CloseableIterable<?> iterable, Class<T> type) {
        return CloseableIterables.wrap(Iterables.filter(iterable, type), iterable);
    }

    public static <T> CloseableIterable<T> filter(CloseableIterable<T> iterable, Predicate<? super T> filter) {
        return CloseableIterables.wrap(Iterables.filter(iterable, filter::test), iterable);
    }

    public static <T> CloseableIterable<T> limit(CloseableIterable<T> iterable, int limitSize) {
        return CloseableIterables.wrap(Iterables.limit(iterable, (int)limitSize), iterable);
    }

    public static <T> CloseableIterable<List<T>> paddedParition(CloseableIterable<T> iterable, int size) {
        return CloseableIterables.wrap(Iterables.paddedPartition(iterable, (int)size), iterable);
    }

    public static <T> CloseableIterable<List<T>> partition(CloseableIterable<T> iterable, int size) {
        return CloseableIterables.wrap(Iterables.partition(iterable, (int)size), iterable);
    }

    public static <T> CloseableIterable<T> skip(CloseableIterable<T> iterable, int numberToSkip) {
        return CloseableIterables.wrap(Iterables.skip(iterable, (int)numberToSkip), iterable);
    }

    public static <F, T> CloseableIterable<T> transform(CloseableIterable<F> iterable, Function<? super F, ? extends T> function) {
        return CloseableIterables.wrap(Iterables.transform(iterable, function::apply), iterable);
    }

    @SafeVarargs
    public static <T> CloseableIterable<T> chain(CloseableIterable<? extends T> ... iterables) {
        return CloseableIterables.chain(Arrays.asList(iterables));
    }

    public static <T> CloseableIterable<T> chain(final Iterable<? extends CloseableIterable<? extends T>> iterables) {
        Objects.requireNonNull(iterables);
        return new FluentCloseableIterable<T>(){

            @Override
            protected void doClose() {
                for (CloseableIterable curr : iterables) {
                    curr.closeQuietly();
                }
            }

            @Override
            protected Iterator<T> retrieveIterator() {
                return Iterators.concat((Iterator)CloseableIterables.iterators(iterables));
            }
        };
    }

    public static <T> CloseableIterable<T> autoClose(final CloseableIterable<? extends T> iterable) {
        Objects.requireNonNull(iterable);
        return new FluentCloseableIterable<T>(){

            @Override
            protected void doClose() {
                iterable.close();
            }

            @Override
            protected Iterator<T> retrieveIterator() {
                return CloseableIterators.autoClose(CloseableIterators.wrap(iterable.iterator(), iterable));
            }
        };
    }

    public static <T> CloseableIterable<T> emptyIterable() {
        return EMPTY_ITERABLE;
    }

    public static <T> CloseableIterable<T> singleton(T value) {
        return CloseableIterables.fromIterable(Collections.singleton(value));
    }

    @Deprecated
    public static <T> CloseableIterable<T> wrap(Iterable<T> iterable) {
        return CloseableIterables.fromIterable(iterable);
    }

    static <T> FluentCloseableIterable<T> wrap(final Iterable<T> iterable, final AutoCloseable closeable) {
        return new FluentCloseableIterable<T>(){

            @Override
            protected void doClose() {
                try {
                    closeable.close();
                }
                catch (RuntimeException re) {
                    throw re;
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            }

            @Override
            protected Iterator<T> retrieveIterator() {
                return iterable.iterator();
            }
        };
    }

    private static <T> UnmodifiableIterator<Iterator<? extends T>> iterators(Iterable<? extends CloseableIterable<? extends T>> iterables) {
        final Iterator<? extends CloseableIterable<? extends T>> iterableIterator = iterables.iterator();
        return new UnmodifiableIterator<Iterator<? extends T>>(){

            public boolean hasNext() {
                return iterableIterator.hasNext();
            }

            public Iterator<? extends T> next() {
                return ((Iterable)iterableIterator.next()).iterator();
            }
        };
    }
}

