/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.mango.collect;

import com.google.common.collect.Iterators;
import com.google.common.collect.PeekingIterator;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.calrissian.mango.collect.CloseableIterator;
import org.calrissian.mango.collect.Iterators2;
import org.calrissian.mango.collect.PeekingCloseableIterator;

public class CloseableIterators {
    private static final CloseableIterator EMPTY_ITERATOR = CloseableIterators.fromIterator(Collections.emptyIterator());

    private CloseableIterators() {
    }

    public static <T> CloseableIterator<T> fromStream(Stream<T> stream) {
        return CloseableIterators.wrap(stream.iterator(), stream);
    }

    public static <T> CloseableIterator<T> fromIterator(final Iterator<T> iterator) {
        Objects.requireNonNull(iterator);
        if (iterator instanceof CloseableIterator) {
            return (CloseableIterator)iterator;
        }
        return new CloseableIterator<T>(){

            @Override
            public void close() {
                if (iterator instanceof AutoCloseable) {
                    try {
                        ((AutoCloseable)((Object)iterator)).close();
                    }
                    catch (RuntimeException re) {
                        throw re;
                    }
                    catch (Exception e) {
                        throw new IllegalStateException(e);
                    }
                }
            }

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public T next() {
                return iterator.next();
            }

            @Override
            public void remove() {
                iterator.remove();
            }
        };
    }

    public static <T> CloseableIterator<T> distinct(CloseableIterator<T> iterator) {
        return CloseableIterators.wrap(Iterators2.distinct(iterator), iterator);
    }

    public static <T> CloseableIterator<List<T>> groupBy(CloseableIterator<? extends T> iterator, Function<? super T, ?> groupingFunction) {
        return CloseableIterators.wrap(Iterators2.groupBy(iterator, groupingFunction), iterator);
    }

    public static <T> CloseableIterator<T> concat(CloseableIterator<? extends Iterator<? extends T>> iterators) {
        return CloseableIterators.wrap(Iterators.concat(iterators), iterators);
    }

    public static <T> CloseableIterator<T> emptyIterator() {
        return EMPTY_ITERATOR;
    }

    public static <T> CloseableIterator<T> filter(CloseableIterator<T> iterator, Predicate<T> filter) {
        return CloseableIterators.wrap(Iterators.filter(iterator, filter::test), iterator);
    }

    public static <T> CloseableIterator<T> filter(CloseableIterator<?> iterator, Class<T> type) {
        return CloseableIterators.wrap(Iterators.filter(iterator, type), iterator);
    }

    public static <T> CloseableIterator<T> limit(CloseableIterator<T> iterator, int limitSize) {
        return CloseableIterators.wrap(Iterators.limit(iterator, (int)limitSize), iterator);
    }

    public static <T> CloseableIterator<List<T>> paddedParition(CloseableIterator<T> iterator, int size) {
        return CloseableIterators.wrap(Iterators.paddedPartition(iterator, (int)size), iterator);
    }

    public static <T> CloseableIterator<List<T>> partition(CloseableIterator<T> iterator, int size) {
        return CloseableIterators.wrap(Iterators.partition(iterator, (int)size), iterator);
    }

    public static <T> PeekingCloseableIterator<T> peekingIterator(final CloseableIterator<T> iterator) {
        final PeekingIterator peeking = Iterators.peekingIterator(iterator);
        return new PeekingCloseableIterator<T>(){

            @Override
            public void close() {
                iterator.close();
            }

            public T peek() {
                return peeking.peek();
            }

            @Override
            public T next() {
                return peeking.next();
            }

            @Override
            public void remove() {
                peeking.remove();
            }

            @Override
            public boolean hasNext() {
                return peeking.hasNext();
            }
        };
    }

    public static <T> CloseableIterator<T> singletonIterator(T value) {
        return CloseableIterators.fromIterator(Iterators.singletonIterator(value));
    }

    public static <F, T> CloseableIterator<T> transform(CloseableIterator<F> iterator, Function<F, T> function) {
        return CloseableIterators.wrap(Iterators.transform(iterator, function::apply), iterator);
    }

    @SafeVarargs
    public static <T> CloseableIterator<T> chain(CloseableIterator<? extends T> ... iterators) {
        return CloseableIterators.chain(Iterators.forArray((Object[])iterators));
    }

    public static <T> CloseableIterator<T> chain(final Iterator<? extends CloseableIterator<? extends T>> iterator) {
        Objects.requireNonNull(iterator);
        return new CloseableIterator<T>(){
            CloseableIterator<? extends T> curr = CloseableIterators.emptyIterator();

            @Override
            public void close() {
                if (this.curr != null) {
                    this.curr.closeQuietly();
                }
                while (iterator.hasNext()) {
                    ((CloseableIterator)iterator.next()).closeQuietly();
                }
            }

            @Override
            public boolean hasNext() {
                while (!this.curr.hasNext() && iterator.hasNext()) {
                    this.curr = CloseableIterators.autoClose((CloseableIterator)iterator.next());
                }
                return this.curr.hasNext();
            }

            @Override
            public T next() {
                if (this.hasNext()) {
                    return this.curr.next();
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                this.curr.remove();
            }
        };
    }

    public static <T> CloseableIterator<T> autoClose(final CloseableIterator<? extends T> iterator) {
        Objects.requireNonNull(iterator);
        return new CloseableIterator<T>(){
            private boolean closed = false;

            @Override
            public void close() {
                if (this.closed) {
                    return;
                }
                this.closed = true;
                iterator.close();
            }

            @Override
            public boolean hasNext() {
                try {
                    if (this.closed) {
                        return false;
                    }
                    if (!iterator.hasNext()) {
                        this.closeQuietly();
                        return false;
                    }
                    return true;
                }
                catch (RuntimeException re) {
                    this.closeQuietly();
                    throw re;
                }
            }

            @Override
            public T next() {
                if (!this.closed) {
                    try {
                        return iterator.next();
                    }
                    catch (RuntimeException re) {
                        this.closeQuietly();
                        throw re;
                    }
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                if (!this.closed) {
                    try {
                        iterator.remove();
                    }
                    catch (RuntimeException re) {
                        this.closeQuietly();
                        throw re;
                    }
                }
                throw new IllegalStateException();
            }
        };
    }

    @Deprecated
    public static <T> CloseableIterator<T> wrap(Iterator<T> iterator) {
        return CloseableIterators.fromIterator(iterator);
    }

    static <T> CloseableIterator<T> wrap(final Iterator<T> iterator, final AutoCloseable closeable) {
        return new CloseableIterator<T>(){

            @Override
            public void close() {
                try {
                    closeable.close();
                }
                catch (RuntimeException re) {
                    throw re;
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            }

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public T next() {
                return iterator.next();
            }

            @Override
            public void remove() {
                iterator.remove();
            }
        };
    }
}

