/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.mango.collect;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Ordering;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import org.calrissian.mango.collect.AbstractCloseableIterable;
import org.calrissian.mango.collect.CloseableIterable;
import org.calrissian.mango.collect.CloseableIterables;
import org.calrissian.mango.collect.Iterables2;

public abstract class FluentCloseableIterable<T>
extends AbstractCloseableIterable<T> {
    protected FluentCloseableIterable() {
    }

    public static <E> FluentCloseableIterable<E> from(final CloseableIterable<E> iterable) {
        return iterable instanceof FluentCloseableIterable ? (FluentCloseableIterable<Object>)iterable : new FluentCloseableIterable<E>(){

            @Override
            protected void doClose() {
                iterable.close();
            }

            @Override
            protected Iterator<E> retrieveIterator() {
                return iterable.iterator();
            }
        };
    }

    public final FluentCloseableIterable<T> autoClose() {
        return FluentCloseableIterable.from(CloseableIterables.autoClose(this));
    }

    public String toString() {
        return Iterables.toString((Iterable)this);
    }

    public final int size() {
        return Iterables.size((Iterable)this);
    }

    public final boolean contains(Object target) {
        return Iterables.contains((Iterable)this, (Object)target);
    }

    public final FluentCloseableIterable<T> cycle() {
        return FluentCloseableIterable.from(CloseableIterables.cycle(this));
    }

    public final FluentCloseableIterable<T> append(Iterable<? extends T> other) {
        return FluentCloseableIterable.from(CloseableIterables.wrap(Iterables.concat((Iterable)this, other), this));
    }

    @SafeVarargs
    public final FluentCloseableIterable<T> append(T ... elements) {
        return FluentCloseableIterable.from(CloseableIterables.wrap(Iterables.concat((Iterable)this, Arrays.asList(elements)), this));
    }

    public final FluentCloseableIterable<T> filter(Predicate<? super T> predicate) {
        return FluentCloseableIterable.from(CloseableIterables.filter(this, predicate));
    }

    public final <E> FluentCloseableIterable<E> filter(Class<E> type) {
        return FluentCloseableIterable.from(CloseableIterables.filter(this, type));
    }

    public final boolean anyMatch(Predicate<? super T> predicate) {
        return Iterables.any((Iterable)this, predicate::test);
    }

    public final boolean allMatch(Predicate<? super T> predicate) {
        return Iterables.all((Iterable)this, predicate::test);
    }

    public final Optional<T> firstMatch(Predicate<? super T> predicate) {
        return Optional.ofNullable(Iterables.tryFind((Iterable)this, predicate::test).orNull());
    }

    public final <E> FluentCloseableIterable<E> transform(Function<? super T, ? extends E> function) {
        return FluentCloseableIterable.from(CloseableIterables.transform(this, function));
    }

    public final <E> FluentCloseableIterable<E> transformAndConcat(Function<? super T, ? extends Iterable<E>> function) {
        return FluentCloseableIterable.from(CloseableIterables.concat(this.transform(function)));
    }

    public final Optional<T> first() {
        Iterator iterator = this.iterator();
        return iterator.hasNext() ? Optional.of(iterator.next()) : Optional.empty();
    }

    public final Optional<T> last() {
        Object current;
        Iterator iterator = this.iterator();
        if (!iterator.hasNext()) {
            return Optional.empty();
        }
        do {
            current = iterator.next();
        } while (iterator.hasNext());
        return Optional.of(current);
    }

    public final FluentCloseableIterable<T> skip(int numberToSkip) {
        return FluentCloseableIterable.from(CloseableIterables.skip(this, numberToSkip));
    }

    public final FluentCloseableIterable<T> limit(int size) {
        return FluentCloseableIterable.from(CloseableIterables.limit(this, size));
    }

    public final boolean isEmpty() {
        return !this.iterator().hasNext();
    }

    public final ImmutableList<T> toList() {
        return ImmutableList.copyOf((Iterable)this);
    }

    public final ImmutableList<T> toSortedList(Comparator<? super T> comparator) {
        return Ordering.from(comparator).immutableSortedCopy((Iterable)this);
    }

    public final ImmutableSet<T> toSet() {
        return ImmutableSet.copyOf((Iterable)this);
    }

    public final ImmutableSortedSet<T> toSortedSet(Comparator<? super T> comparator) {
        return ImmutableSortedSet.copyOf(comparator, (Iterable)this);
    }

    public final ImmutableMultiset<T> toMultiset() {
        return ImmutableMultiset.copyOf((Iterable)this);
    }

    public final <V> ImmutableMap<T, V> toMap(Function<? super T, V> valueFunction) {
        return Maps.toMap((Iterable)this, valueFunction::apply);
    }

    public final <K> ImmutableListMultimap<K, T> index(Function<? super T, K> keyFunction) {
        return Multimaps.index((Iterable)this, keyFunction::apply);
    }

    public final <K> ImmutableMap<K, T> uniqueIndex(Function<? super T, K> keyFunction) {
        return Maps.uniqueIndex((Iterable)this, keyFunction::apply);
    }

    public final T[] toArray(Class<T> type) {
        return Iterables.toArray((Iterable)this, type);
    }

    public final <C extends Collection<? super T>> C copyInto(C collection) {
        Objects.requireNonNull(collection);
        for (Object item : this) {
            collection.add(item);
        }
        return collection;
    }

    public final String join(Joiner joiner) {
        return joiner.join((Iterable)this);
    }

    public final T get(int position) {
        return (T)Iterables.get((Iterable)this, (int)position);
    }

    public final Iterable<T> toSimpleIterable() {
        return Iterables2.simpleIterable(this);
    }
}

