/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.mango.domain;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class Attribute<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final String key;
    protected final T value;
    protected final Map<String, String> metadata;

    public Attribute(String key, T value) {
        this(key, value, Collections.emptyMap());
    }

    public Attribute(String key, T value, Map<String, String> metadata) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(value);
        Objects.requireNonNull(metadata);
        this.key = key;
        this.value = value;
        this.metadata = new HashMap<String, String>(metadata);
    }

    public String getKey() {
        return this.key;
    }

    public T getValue() {
        return this.value;
    }

    public Set<String> metadataKeys() {
        return Collections.unmodifiableSet(this.metadata.keySet());
    }

    public String getMetadataValue(String key) {
        return this.metadata.get(key);
    }

    public Map<String, String> getMetadata() {
        return Collections.unmodifiableMap(this.metadata);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Attribute)) {
            return false;
        }
        Attribute attribute = (Attribute)o;
        if (!this.key.equals(attribute.key)) {
            return false;
        }
        if (!this.metadata.equals(attribute.metadata)) {
            return false;
        }
        return this.value.equals(attribute.value);
    }

    public int hashCode() {
        int result = this.key.hashCode();
        result = 31 * result + this.value.hashCode();
        result = 31 * result + this.metadata.hashCode();
        return result;
    }

    public String toString() {
        return "Attribute{key='" + this.key + '\'' + ", value=" + this.value + ", metadata=" + this.metadata + '}';
    }
}

