/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.mango.domain.event;

import java.util.Objects;
import org.calrissian.mango.domain.AbstractAttributeStoreBuilder;
import org.calrissian.mango.domain.Attribute;
import org.calrissian.mango.domain.event.BaseEvent;
import org.calrissian.mango.domain.event.Event;
import org.calrissian.mango.domain.event.EventIdentifier;

public class EventBuilder
extends AbstractAttributeStoreBuilder<Event, EventBuilder> {
    private final EventIdentifier identifier;

    public static EventBuilder create(EventIdentifier identifier) {
        Objects.requireNonNull(identifier);
        return new EventBuilder(identifier);
    }

    public static EventBuilder create(String type, String id, long timestamp) {
        return EventBuilder.create(new EventIdentifier(type, id, timestamp));
    }

    public static EventBuilder create(Event event) {
        return (EventBuilder)EventBuilder.create(event.getIdentifier()).attrs(event.getAttributes());
    }

    protected EventBuilder(EventIdentifier identifier) {
        this.identifier = identifier;
    }

    @Override
    public Event build() {
        return new BaseEvent(this.identifier, (Iterable<? extends Attribute>)this.attributes);
    }
}

