/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.mango.types;

import com.google.common.collect.Iterables;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.calrissian.mango.types.TypeEncoder;
import org.calrissian.mango.types.exception.TypeDecodingException;
import org.calrissian.mango.types.exception.TypeEncodingException;

public class TypeRegistry<U>
implements Serializable {
    private final Map<String, TypeEncoder<?, U>> aliasMapping = new LinkedHashMap();
    private final Map<Class<?>, TypeEncoder<?, U>> classMapping = new LinkedHashMap();

    public TypeRegistry(TypeEncoder<?, U> ... normalizers) {
        this(Arrays.asList(normalizers));
    }

    public TypeRegistry(TypeRegistry<U> registry, TypeEncoder<?, U> ... normalizers) {
        this(Iterables.concat(Arrays.asList(normalizers), registry.getAllEncoders()));
    }

    public TypeRegistry(Iterable<TypeEncoder<?, U>> normalizers) {
        Objects.requireNonNull(normalizers);
        for (TypeEncoder<?, U> resolver : normalizers) {
            if (this.aliasMapping.containsKey(resolver.getAlias())) {
                throw new IllegalArgumentException("The aliases provided by the TypeEncoder must be unique");
            }
            if (this.classMapping.containsKey(resolver.resolves())) {
                throw new IllegalArgumentException("There can only be one TypeEncoder per class type.");
            }
            this.aliasMapping.put(resolver.getAlias(), resolver);
            this.classMapping.put(resolver.resolves(), resolver);
        }
    }

    public String getAlias(Object obj) {
        if (obj == null) {
            return null;
        }
        return this.getClassAlias(obj.getClass());
    }

    public String getClassAlias(Class clazz) {
        if (clazz == null) {
            return null;
        }
        TypeEncoder<?, U> encoder = this.classMapping.get(clazz);
        if (encoder != null) {
            return encoder.getAlias();
        }
        return null;
    }

    public U encode(Object value) {
        Objects.requireNonNull(value, "Value for encoding can not be null");
        TypeEncoder<?, U> encoder = this.classMapping.get(value.getClass());
        if (encoder != null) {
            return encoder.encode(value);
        }
        throw new TypeEncodingException("An unknown type [" + value.getClass() + "] was encountered");
    }

    public Object decode(String alias, U value) {
        Objects.requireNonNull(alias, "Not allowed to have a null alias");
        Objects.requireNonNull(value, "Value for decoding can not be null");
        TypeEncoder<?, U> encoder = this.aliasMapping.get(alias);
        if (encoder != null) {
            return encoder.decode(value);
        }
        throw new TypeDecodingException("An unknown alias [" + alias + "] was encountered");
    }

    public Collection<TypeEncoder<?, U>> getAllEncoders() {
        return Collections.unmodifiableCollection(this.classMapping.values());
    }
}

