/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.mango.types.encoders.lexi;

import com.google.common.base.Preconditions;
import java.math.BigInteger;
import java.util.Objects;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.calrissian.mango.types.encoders.AbstractBigIntegerEncoder;
import org.calrissian.mango.types.encoders.lexi.IntegerEncoder;
import org.calrissian.mango.types.exception.TypeDecodingException;

public class BigIntegerEncoder
extends AbstractBigIntegerEncoder<String> {
    private static final long serialVersionUID = 1L;
    private static IntegerEncoder integerEncoder = new IntegerEncoder();

    @Override
    public String encode(BigInteger value) {
        Objects.requireNonNull(value, "Null values are not allowed");
        byte[] bytes = value.toByteArray();
        int length = bytes.length;
        if (value.signum() < 0) {
            length = -length;
        }
        return integerEncoder.encode(length) + new String(Hex.encodeHex((byte[])bytes));
    }

    @Override
    public BigInteger decode(String value) throws TypeDecodingException {
        Objects.requireNonNull(value, "Null values are not allowed");
        Preconditions.checkArgument((value.length() > 8 ? 1 : 0) != 0, (Object)"The value is not a valid encoding");
        try {
            return new BigInteger(Hex.decodeHex((char[])value.substring(8).toCharArray()));
        }
        catch (DecoderException e) {
            throw new TypeDecodingException(e);
        }
    }
}

