/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.mango.types.encoders.lexi;

import com.google.common.base.Preconditions;
import java.util.Objects;
import org.calrissian.mango.domain.event.EventIdentifier;
import org.calrissian.mango.types.encoders.AbstractEventIdentifierEncoder;
import org.calrissian.mango.types.encoders.lexi.LongEncoder;
import org.calrissian.mango.types.exception.TypeDecodingException;
import org.calrissian.mango.types.exception.TypeEncodingException;

public class EventIdentifierEncoder
extends AbstractEventIdentifierEncoder<String> {
    private static final long serialVersionUID = 1L;
    private static final String SCHEME = "event://";
    private static final LongEncoder longEncoder = new LongEncoder();

    @Override
    public String encode(EventIdentifier value) throws TypeEncodingException {
        Objects.requireNonNull(value, "Null values are not allowed");
        return String.format("%s%s#%s@%s", SCHEME, value.getType(), value.getId(), longEncoder.encode(value.getTimestamp()));
    }

    @Override
    public EventIdentifier decode(String value) throws TypeDecodingException {
        Objects.requireNonNull(value, "Null values are not allowed");
        Preconditions.checkArgument((value.startsWith(SCHEME) && value.contains("#") && value.contains("@") ? 1 : 0) != 0, (Object)"The value is not a valid encoding");
        String rel = value.substring(SCHEME.length());
        int idx = rel.indexOf(35);
        int tsIdx = rel.lastIndexOf(64);
        return new EventIdentifier(rel.substring(0, idx), rel.substring(idx + 1, tsIdx), longEncoder.decode(rel.substring(tsIdx + 1)));
    }
}

