/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.mango.types.encoders.lexi;

import com.google.common.base.Preconditions;
import java.util.Objects;
import org.calrissian.mango.types.encoders.AbstractFloatEncoder;
import org.calrissian.mango.types.encoders.lexi.EncodingUtils;

public class FloatReverseEncoder
extends AbstractFloatEncoder<String> {
    private static final long serialVersionUID = 1L;

    @Override
    public String encode(Float value) {
        Objects.requireNonNull(value, "Null values are not allowed");
        return EncodingUtils.encodeUInt(~EncodingUtils.normalizeFloat(value.floatValue()));
    }

    @Override
    public Float decode(String value) {
        Objects.requireNonNull(value, "Null values are not allowed");
        Preconditions.checkArgument((value.length() == 8 ? 1 : 0) != 0, (Object)"The value is not a valid encoding");
        return Float.valueOf(EncodingUtils.denormalizeFloat(~((int)EncodingUtils.fromHex(value))));
    }
}

