/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.mango.types.encoders.lexi;

import com.google.common.base.Preconditions;
import java.net.Inet6Address;
import java.net.UnknownHostException;
import java.util.Objects;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.calrissian.mango.types.encoders.AbstractInet6AddressEncoder;
import org.calrissian.mango.types.encoders.lexi.EncodingUtils;
import org.calrissian.mango.types.exception.TypeDecodingException;

public class Inet6AddressReverseEncoder
extends AbstractInet6AddressEncoder<String> {
    @Override
    public String encode(Inet6Address value) {
        Objects.requireNonNull(value, "Null values are not allowed");
        return Hex.encodeHexString((byte[])EncodingUtils.reverse(value.getAddress()));
    }

    @Override
    public Inet6Address decode(String value) {
        Objects.requireNonNull(value, "Null values are not allowed");
        Preconditions.checkArgument((value.length() == 32 ? 1 : 0) != 0, (Object)"The value is not a valid encoding");
        try {
            return Inet6Address.getByAddress(null, EncodingUtils.reverse(Hex.decodeHex((char[])value.toCharArray())), -1);
        }
        catch (UnknownHostException | DecoderException e) {
            throw new TypeDecodingException(e);
        }
    }
}

