/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.mango.types.encoders.lexi;

import com.google.common.base.Preconditions;
import java.time.Instant;
import java.util.Objects;
import org.calrissian.mango.types.encoders.AbstractInstantEncoder;
import org.calrissian.mango.types.encoders.lexi.IntegerReverseEncoder;
import org.calrissian.mango.types.encoders.lexi.LongReverseEncoder;

public class InstantReverseEncoder
extends AbstractInstantEncoder<String> {
    private static final long serialVersionUID = 1L;
    private static final LongReverseEncoder longEncoder = new LongReverseEncoder();
    private static final IntegerReverseEncoder intEncoder = new IntegerReverseEncoder();

    @Override
    public String encode(Instant value) {
        Objects.requireNonNull(value, "Null values are not allowed");
        return longEncoder.encode(value.getEpochSecond()) + intEncoder.encode(value.getNano());
    }

    @Override
    public Instant decode(String value) {
        Objects.requireNonNull(value, "Null values are not allowed");
        Preconditions.checkArgument((value.length() == 24 ? 1 : 0) != 0, (Object)"The value is not a valid encoding");
        return Instant.ofEpochSecond(longEncoder.decode(value.substring(0, 16)), intEncoder.decode(value.substring(16)).intValue());
    }
}

