/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.mango.types.encoders.lexi;

import com.google.common.base.Preconditions;
import java.util.Objects;
import org.calrissian.mango.types.encoders.AbstractIntegerEncoder;
import org.calrissian.mango.types.encoders.lexi.EncodingUtils;

public class IntegerEncoder
extends AbstractIntegerEncoder<String> {
    private static final long serialVersionUID = 1L;

    @Override
    public String encode(Integer value) {
        Objects.requireNonNull(value, "Null values are not allowed");
        return EncodingUtils.encodeUInt(value ^ Integer.MIN_VALUE);
    }

    @Override
    public Integer decode(String value) {
        Objects.requireNonNull(value, "Null values are not allowed");
        Preconditions.checkArgument((value.length() == 8 ? 1 : 0) != 0, (Object)"The value is not a valid encoding");
        return (int)EncodingUtils.fromHex(value) ^ Integer.MIN_VALUE;
    }
}

