/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.mango.types.encoders.lexi;

import com.google.common.base.Preconditions;
import java.util.Objects;
import org.calrissian.mango.types.encoders.AbstractLongEncoder;
import org.calrissian.mango.types.encoders.lexi.EncodingUtils;

public class LongEncoder
extends AbstractLongEncoder<String> {
    private static final long serialVersionUID = 1L;

    @Override
    public String encode(Long value) {
        Objects.requireNonNull(value, "Null values are not allowed");
        return EncodingUtils.encodeULong(value ^ Long.MIN_VALUE);
    }

    @Override
    public Long decode(String value) {
        Objects.requireNonNull(value, "Null values are not allowed");
        Preconditions.checkArgument((value.length() == 16 ? 1 : 0) != 0, (Object)"The value is not a valid encoding");
        return EncodingUtils.fromHex(value) ^ Long.MIN_VALUE;
    }
}

