/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.mango.types.encoders.lexi;

import com.google.common.base.Preconditions;
import com.google.common.primitives.UnsignedLong;
import java.util.Objects;
import org.calrissian.mango.types.encoders.AbstractUnsignedLongEncoder;
import org.calrissian.mango.types.encoders.lexi.EncodingUtils;

public class UnsignedLongReverseEncoder
extends AbstractUnsignedLongEncoder<String> {
    private static final long serialVersionUID = 1L;

    @Override
    public String encode(UnsignedLong value) {
        Objects.requireNonNull(value, "Null values are not allowed");
        return EncodingUtils.encodeULong(value.longValue() ^ 0xFFFFFFFFFFFFFFFFL);
    }

    @Override
    public UnsignedLong decode(String value) {
        Objects.requireNonNull(value, "Null values are not allowed");
        Preconditions.checkArgument((value.length() == 16 ? 1 : 0) != 0, (Object)"The value is not a valid encoding");
        return UnsignedLong.fromLongBits((long)(~((int)EncodingUtils.fromHex(value))));
    }
}

