/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.mango.types.encoders.simple;

import java.util.Objects;
import org.calrissian.mango.types.encoders.AbstractBooleanEncoder;

public class BooleanEncoder
extends AbstractBooleanEncoder<String> {
    private static final long serialVersionUID = 1L;

    @Override
    public String encode(Boolean value) {
        Objects.requireNonNull(value, "Null values are not allowed");
        return value.toString();
    }

    @Override
    public Boolean decode(String value) {
        Objects.requireNonNull(value, "Null values are not allowed");
        String lowercase = value.toLowerCase();
        if (!lowercase.equals("true") && !lowercase.equals("false")) {
            throw new IllegalArgumentException("The value is not a valid encoding");
        }
        return Boolean.parseBoolean(lowercase);
    }
}

