/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.mango.criteria.domain;

import java.util.Objects;
import org.calrissian.mango.criteria.domain.Node;
import org.calrissian.mango.criteria.domain.ParentNode;
import org.calrissian.mango.criteria.domain.TypedTermLeaf;

public class RangeLeaf<T>
extends TypedTermLeaf<T> {
    private final T start;
    private final T end;

    public RangeLeaf(String term, T start, T end, ParentNode parent) {
        super(term, RangeLeaf.firstKnownType(start, end), parent);
        this.start = Objects.requireNonNull(start);
        this.end = Objects.requireNonNull(end);
    }

    public Object getStart() {
        return this.start;
    }

    public Object getEnd() {
        return this.end;
    }

    @Override
    public Node clone(ParentNode node) {
        return new RangeLeaf<Object>(this.getTerm(), this.getStart(), this.getEnd(), node);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RangeLeaf rangeLeaf = (RangeLeaf)o;
        return Objects.equals(this.start, rangeLeaf.start) && Objects.equals(this.end, rangeLeaf.end);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.start, this.end);
    }

    public String toString() {
        return this.getTerm() + " within [" + this.start + "," + this.end + "]";
    }
}

