/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.mango.criteria.domain.criteria;

import java.util.Comparator;
import java.util.Objects;
import org.calrissian.mango.criteria.domain.criteria.Criteria;
import org.calrissian.mango.criteria.domain.criteria.ParentCriteria;
import org.calrissian.mango.criteria.domain.criteria.TermCriteria;
import org.calrissian.mango.domain.Attribute;
import org.calrissian.mango.domain.AttributeStore;

public class RangeCriteria<T>
extends TermCriteria {
    private final T start;
    private final T end;
    private final Comparator<T> comparator;

    public RangeCriteria(String term, T start, T end, Comparator<T> comparator, ParentCriteria parentCriteria) {
        super(term, parentCriteria);
        this.start = Objects.requireNonNull(start);
        this.end = Objects.requireNonNull(end);
        this.comparator = Objects.requireNonNull(comparator);
    }

    @Override
    public boolean test(AttributeStore obj) {
        for (Attribute attribute : obj.getAttributes(this.getTerm())) {
            if (this.comparator.compare(attribute.getValue(), this.start) < 0 || this.comparator.compare(attribute.getValue(), this.end) > 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public Criteria clone(ParentCriteria parentCriteria) {
        return new RangeCriteria<T>(this.getTerm(), this.start, this.end, this.comparator, parentCriteria);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RangeCriteria that = (RangeCriteria)o;
        return Objects.equals(this.start, that.start) && Objects.equals(this.end, that.end) && Objects.equals(this.comparator, that.comparator);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.start, this.end, this.comparator);
    }

    @Override
    public String toString() {
        return this.getTerm() + " within [" + this.start + "," + this.end + "]";
    }
}

