/*
 * Copyright (C) 2013 The Calrissian Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.calrissian.mango.jms.stream.domain;

import java.io.Serializable;

public class Metadata implements Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = 2106165237211114549L;

	private int numberOfPieces;

	private long pieceSize;

	private String fileName;

	private long fileSize;

	public Metadata(int numberOfPieces, long pieceSize, String fileName,
			long fileSize) {
		super();
		this.numberOfPieces = numberOfPieces;
		this.pieceSize = pieceSize;
		this.fileName = fileName;
		this.fileSize = fileSize;
	}

	public long getFileSize() {
		return fileSize;
	}

	public int getNumberOfPieces() {
		return numberOfPieces;
	}

	public long getPieceSize() {
		return pieceSize;
	}

	public String getFileName() {
		return fileName;
	}
}