/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.mango.jms.stream;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.UUID;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Session;
import org.calrissian.mango.jms.stream.JmsFileReceiverInputStream;
import org.calrissian.mango.jms.stream.JmsFileTransferException;
import org.calrissian.mango.jms.stream.domain.Piece;
import org.calrissian.mango.jms.stream.domain.Request;
import org.calrissian.mango.jms.stream.domain.Response;
import org.calrissian.mango.jms.stream.domain.ResponseStatusEnum;
import org.calrissian.mango.jms.stream.utils.DestinationRequestor;
import org.calrissian.mango.jms.stream.utils.DomainMessageUtils;
import org.calrissian.mango.jms.stream.utils.MessageQueueListener;
import org.calrissian.mango.uri.support.UriStreamOpener;
import org.calrissian.mango.uri.support.impl.BasicStreamOpener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.core.MessageCreator;
import org.springframework.jms.core.SessionCallback;
import org.springframework.util.Assert;

public abstract class AbstractJmsFileTransferSupport {
    Logger logger = LoggerFactory.getLogger(this.getClass());
    protected JmsTemplate jmsTemplate;
    private int pieceSize = 10240;
    private Destination streamRequestDestination;
    private String hashAlgorithm;
    private UriStreamOpener streamOpener = new BasicStreamOpener();
    private Logger logService;

    public void setStreamOpener(UriStreamOpener streamOpener) {
        this.streamOpener = streamOpener;
    }

    protected String generateId() {
        return UUID.randomUUID().toString();
    }

    public JmsTemplate getJmsTemplate() {
        return this.jmsTemplate;
    }

    public int getPieceSize() {
        return this.pieceSize;
    }

    public Destination getStreamRequestDestination() {
        return this.streamRequestDestination;
    }

    public InputStream receiveStream(final Request req) throws JmsFileTransferException {
        try {
            this.logger.info("Broadcasting request for [" + req.getDownloadUri() + "] and id[" + req.getRequestId() + "]");
            Message returnMessage = this.sendWithResponse(new MessageCreator(){

                public Message createMessage(Session session) throws JMSException {
                    return DomainMessageUtils.toRequestMessage(session, req);
                }
            }, this.getStreamRequestDestination());
            if (returnMessage == null) {
                this.logger.info("No one can fullfil this request [" + req.getDownloadUri() + "]");
                return null;
            }
            Destination receiveAckDestination = returnMessage.getJMSReplyTo();
            String sendDataDestination = UUID.randomUUID().toString();
            this.logger.info("Receiver[" + req.getRequestId() + "]: File Transfer starting");
            return new JmsFileReceiverInputStream(this, sendDataDestination, receiveAckDestination);
        }
        catch (Exception e) {
            throw new JmsFileTransferException(e);
        }
    }

    public void sendStream(Request req, final Destination replyTo) throws IOException {
        URI downloadUrl;
        DigestInputStream is = null;
        Assert.notNull((Object)req, (String)"Request cannot be null");
        try {
            downloadUrl = new URI(req.getDownloadUri());
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
        try {
            is = new DigestInputStream(new BufferedInputStream(this.streamOpener.openStream(downloadUrl)), MessageDigest.getInstance(this.getHashAlgorithm()));
        }
        catch (NoSuchAlgorithmException e) {
            throw new JmsFileTransferException(e);
        }
        catch (Throwable e) {
            this.logger.info("Error occurred opening stream: " + e);
            return;
        }
        MessageQueueListener queueListener = null;
        try {
            Response ackResponse;
            Message returnMessage = (Message)this.jmsTemplate.execute(new SessionCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object doInJms(Session session) throws JMSException {
                    DestinationRequestor requestor = null;
                    try {
                        Message responseMessage = DomainMessageUtils.toResponseMessage(session, new Response(ResponseStatusEnum.ACCEPT));
                        Destination streamTransferDestination = AbstractJmsFileTransferSupport.this.factoryDestination(session, UUID.randomUUID().toString());
                        requestor = new DestinationRequestor(session, replyTo, streamTransferDestination, AbstractJmsFileTransferSupport.this.jmsTemplate.getReceiveTimeout());
                        Message returnMessage = requestor.request(responseMessage);
                        requestor.close();
                        Message message = returnMessage;
                        return message;
                    }
                    finally {
                        if (requestor != null) {
                            requestor.close();
                        }
                    }
                }
            }, true);
            if (returnMessage == null) {
                return;
            }
            Response response = DomainMessageUtils.fromResponseMessage(returnMessage);
            if (!ResponseStatusEnum.STARTSEND.equals((Object)response.getStatus())) {
                return;
            }
            Destination receiveAckDestination = returnMessage.getJMSDestination();
            Destination sendDataDestination = returnMessage.getJMSReplyTo();
            queueListener = new MessageQueueListener(this, receiveAckDestination);
            this.logger.info("Sender[" + req.getRequestId() + "]: Starting send to: " + sendDataDestination);
            byte[] buffer = new byte[this.getPieceSize()];
            int read = is.read(buffer);
            long placeInFile = 0L;
            while (read >= 0) {
                ByteArrayOutputStream stream = new ByteArrayOutputStream();
                stream.write(buffer, 0, read);
                stream.close();
                byte[] pieceData = stream.toByteArray();
                final Piece piece = new Piece(placeInFile, pieceData, this.getHashAlgorithm());
                this.logger.info("Sender[" + req.getRequestId() + "]: Sending piece with position: " + piece.getPosition() + " Size of piece: " + pieceData.length);
                this.jmsTemplate.send(sendDataDestination, new MessageCreator(){

                    public Message createMessage(Session session) throws JMSException {
                        return DomainMessageUtils.toPieceMessage(session, piece);
                    }
                });
                Message ret = queueListener.getMessageInQueue();
                this.logger.info("Sender[" + req.getRequestId() + "]: Sent piece and got ack");
                if (ret == null) {
                    return;
                }
                Response res = DomainMessageUtils.fromResponseMessage(ret);
                if (ResponseStatusEnum.RESEND.equals((Object)res.getStatus())) {
                    this.logger.info("Sender[" + req.getRequestId() + "]: Resending piece");
                    continue;
                }
                if (ResponseStatusEnum.DENY.equals((Object)res.getStatus())) {
                    return;
                }
                buffer = new byte[this.getPieceSize()];
                placeInFile += (long)read;
                read = is.read(buffer);
            }
            this.logger.info("Sender[" + req.getRequestId() + "]: Sending stop send");
            final DigestInputStream fiIs = is;
            this.jmsTemplate.send(sendDataDestination, new MessageCreator(){

                public Message createMessage(Session session) throws JMSException {
                    Response stopSendResponse = new Response(ResponseStatusEnum.STOPSEND);
                    stopSendResponse.setHash(new String(fiIs.getMessageDigest().digest()));
                    return DomainMessageUtils.toResponseMessage(session, stopSendResponse);
                }
            });
            Message ackMessage = queueListener.getMessageInQueue();
            Object fromMessage = DomainMessageUtils.fromMessage(ackMessage);
            if (fromMessage instanceof Response && ResponseStatusEnum.RESEND.equals((Object)(ackResponse = (Response)fromMessage).getStatus())) {
                // empty if block
            }
        }
        catch (Exception e) {
            throw new JmsFileTransferException(e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
            if (queueListener != null) {
                queueListener.close();
            }
        }
    }

    protected Message sendWithResponse(final MessageCreator mc, final Destination replyTo) {
        return (Message)this.jmsTemplate.execute(new SessionCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object doInJms(Session session) throws JMSException {
                DestinationRequestor requestor = null;
                try {
                    Message sendMessage = mc.createMessage(session);
                    requestor = new DestinationRequestor(session, replyTo, AbstractJmsFileTransferSupport.this.jmsTemplate.getReceiveTimeout());
                    Message returnMessage = requestor.request(sendMessage);
                    requestor.close();
                    Message message = returnMessage;
                    return message;
                }
                finally {
                    if (requestor != null) {
                        requestor.close();
                    }
                }
            }
        }, true);
    }

    protected Destination factoryDestination(Session session, String destinationName) throws JMSException {
        return this.jmsTemplate.getDestinationResolver().resolveDestinationName(session, destinationName, true);
    }

    public void setJmsTemplate(JmsTemplate jmsTemplate) {
        this.jmsTemplate = jmsTemplate;
    }

    public void setPieceSize(int pieceSize) {
        this.pieceSize = pieceSize;
    }

    public void setStreamRequestDestination(Destination streamRequestDestination) {
        this.streamRequestDestination = streamRequestDestination;
    }

    public void setHashAlgorithm(String hashAlgorithm) {
        this.hashAlgorithm = hashAlgorithm;
    }

    public String getHashAlgorithm() {
        return this.hashAlgorithm;
    }
}

