/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.mango.jms.stream.utils;

import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;

public class DestinationRequestor {
    private long timeout = 0L;
    protected Session session;
    protected Destination topic;
    protected Destination tempDestination;
    protected MessageProducer publisher;
    protected MessageConsumer subscriber;

    public DestinationRequestor(Session session, Destination destination) throws JMSException {
        this(session, destination, 0L);
    }

    public DestinationRequestor(Session session, Destination destination, long timeout) throws JMSException {
        this(session, destination, (Destination)session.createTemporaryTopic(), timeout);
    }

    public DestinationRequestor(Session session, Destination destination, Destination replyTo, long timeout) throws JMSException {
        this.session = session;
        this.topic = destination;
        this.tempDestination = replyTo;
        this.publisher = session.createProducer(destination);
        this.subscriber = session.createConsumer(this.tempDestination);
        this.timeout = timeout;
    }

    public Message request(Message message) throws JMSException {
        message.setJMSReplyTo(this.tempDestination);
        this.publisher.send(message);
        if (this.timeout < 0L) {
            return this.subscriber.receiveNoWait();
        }
        if (this.timeout == 0L) {
            return this.subscriber.receive();
        }
        return this.subscriber.receive(this.timeout);
    }

    public void close() throws JMSException {
        this.close(false);
    }

    public void close(boolean closeSession) throws JMSException {
        this.publisher.close();
        this.subscriber.close();
        if (closeSession) {
            this.session.close();
        }
        if (this.tempDestination instanceof TemporaryQueue) {
            ((TemporaryQueue)this.tempDestination).delete();
        } else if (this.tempDestination instanceof TemporaryTopic) {
            ((TemporaryTopic)this.tempDestination).delete();
        }
    }
}

