/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.mango.jms.stream.utils;

import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Session;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.core.MessageCreator;
import org.springframework.jms.core.MessagePostProcessor;

public class SendReceiveRequestor
implements MessagePostProcessor {
    public static final String RECV_ID = "JMS_SYNC_RECVID";
    public static final String REPLYTO_ID = "JMS_SYNC_REPLYTOID";
    protected Destination topic;
    protected JmsTemplate jmsTemplate;
    protected String recvId;
    protected String replyToId;
    protected boolean send = false;

    public SendReceiveRequestor(JmsTemplate jmsTemplate, Destination destination, String recvId, String replyToId, boolean send) throws JMSException {
        this.jmsTemplate = jmsTemplate;
        this.topic = destination;
        this.replyToId = replyToId;
        this.recvId = recvId;
        this.send = send;
    }

    protected String createReceiveSelector() {
        String s = this.send ? this.replyToId : this.recvId;
        return RECV_ID + " = '" + s + "'";
    }

    protected Message populateProperties(Message msg) throws JMSException {
        String recvS = this.send ? this.recvId : this.replyToId;
        String replyToS = this.send ? this.replyToId : this.recvId;
        msg.setStringProperty(RECV_ID, recvS);
        msg.setStringProperty(REPLYTO_ID, replyToS);
        return msg;
    }

    public static String getReplyToId(Message msg) throws JMSException {
        return msg.getStringProperty(REPLYTO_ID);
    }

    public Message receive() throws JMSException {
        return this.jmsTemplate.receiveSelected(this.topic, this.createReceiveSelector());
    }

    public void send(Message message) throws JMSException {
        message.setJMSReplyTo(this.topic);
        final Message msg = this.populateProperties(message);
        this.jmsTemplate.send(this.topic, new MessageCreator(){

            public Message createMessage(Session session) throws JMSException {
                return msg;
            }
        });
    }

    public void convertAndSend(Object obj) throws JMSException {
        this.jmsTemplate.convertAndSend(this.topic, obj, (MessagePostProcessor)this);
    }

    public void close() throws JMSException {
    }

    public String getReplyToId() {
        return this.replyToId;
    }

    public void setReplyToId(String replyToId) {
        this.replyToId = replyToId;
    }

    public Message postProcessMessage(Message message) throws JMSException {
        Message msg = this.populateProperties(message);
        msg.setJMSReplyTo(this.topic);
        System.out.println("Send: " + msg);
        return msg;
    }
}

