/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.mango.jms.uri;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import org.calrissian.mango.jms.stream.JmsFileReceiver;
import org.calrissian.mango.uri.UriResolver;
import org.calrissian.mango.uri.UriResolverRegistry;
import org.calrissian.mango.uri.exception.BadUriException;
import org.calrissian.mango.uri.exception.ResourceNotFoundException;
import org.calrissian.mango.uri.support.DataResolverFormatUtils;

public class JmsUriReceiver
extends JmsFileReceiver {
    private final UriResolverRegistry resolverRegistry;

    public JmsUriReceiver(UriResolverRegistry resolverRegistry) {
        Preconditions.checkNotNull((Object)resolverRegistry);
        this.resolverRegistry = resolverRegistry;
    }

    public Object resolveUri(String uri, String[] auths) throws IOException {
        try {
            URI theUri = new URI(uri);
            URI requestURI = new URI(theUri.toString().replaceFirst(theUri.getScheme() + ":", ""));
            UriResolver resolver = this.resolverRegistry.getResolver(requestURI);
            if (resolver == null) {
                throw new BadUriException();
            }
            URI uriWithAuths = DataResolverFormatUtils.buildRequestURI((URI)theUri, (String[])auths);
            InputStream is = this.receiveStream(uriWithAuths.toString());
            if (is == null) {
                throw new ResourceNotFoundException();
            }
            return resolver.fromStream(is);
        }
        catch (URISyntaxException e) {
            throw new BadUriException((Throwable)e);
        }
    }
}

