/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.mango.jms.connectionfac;

import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import org.calrissian.mango.jms.connectionfac.SingleDestinationMessageListener;
import org.calrissian.mango.jms.connectionfac.SingleDestinationUtils;
import org.calrissian.mango.jms.connectionfac.decorator.MessageConsumerDecorator;

class SingleDestinationMessageConsumer
extends MessageConsumerDecorator {
    public SingleDestinationMessageConsumer(MessageConsumer messageConsumer) {
        super(messageConsumer);
    }

    @Override
    public MessageListener getMessageListener() throws JMSException {
        return ((SingleDestinationMessageListener)super.getMessageListener()).getInternal();
    }

    @Override
    public void setMessageListener(MessageListener messageListener) throws JMSException {
        super.setMessageListener(new SingleDestinationMessageListener(messageListener));
    }

    @Override
    public Message receive() throws JMSException {
        Message msg = super.receive();
        if (msg != null) {
            SingleDestinationUtils.postReceiveMessage(msg);
        }
        return msg;
    }

    @Override
    public Message receive(long l) throws JMSException {
        Message msg = super.receive(l);
        if (msg != null) {
            SingleDestinationUtils.postReceiveMessage(msg);
        }
        return msg;
    }

    @Override
    public Message receiveNoWait() throws JMSException {
        Message msg = super.receiveNoWait();
        if (msg != null) {
            SingleDestinationUtils.postReceiveMessage(msg);
        }
        return msg;
    }
}

