/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.mango.jms.stream;

import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Session;
import org.calrissian.mango.io.AbstractBufferedInputStream;
import org.calrissian.mango.jms.stream.AbstractJmsFileTransferSupport;
import org.calrissian.mango.jms.stream.JmsFileTransferException;
import org.calrissian.mango.jms.stream.domain.Piece;
import org.calrissian.mango.jms.stream.domain.Response;
import org.calrissian.mango.jms.stream.domain.ResponseStatusEnum;
import org.calrissian.mango.jms.stream.utils.DomainMessageUtils;
import org.calrissian.mango.jms.stream.utils.MessageQueueListener;
import org.springframework.jms.core.MessageCreator;

public class JmsFileReceiverInputStream
extends AbstractBufferedInputStream {
    private boolean done = false;
    private boolean started = false;
    private AbstractJmsFileTransferSupport support;
    private String sendDataDestination;
    private Destination receiveAckDestination;
    private MessageQueueListener messageQueueListener;

    protected JmsFileReceiverInputStream(AbstractJmsFileTransferSupport support, String sendDataDestination, Destination receiveAckDestination) {
        this.support = support;
        this.sendDataDestination = sendDataDestination;
        this.receiveAckDestination = receiveAckDestination;
        this.messageQueueListener = new MessageQueueListener(support, sendDataDestination, true);
    }

    public int read() throws IOException {
        if (!this.started) {
            this.start();
        }
        return super.read();
    }

    protected boolean isEOF() {
        return this.done;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected byte[] getNextBuffer() throws IOException {
        try {
            byte[] data = null;
            Message message = this.messageQueueListener.getMessageInQueue();
            Object object = DomainMessageUtils.fromMessage(message);
            ResponseStatusEnum responseStatus = ResponseStatusEnum.ACCEPT;
            if (object instanceof Piece) {
                Piece piece = (Piece)object;
                String sentHash = piece.getHash();
                if (!new String(MessageDigest.getInstance(this.support.getHashAlgorithm()).digest(piece.getData())).equals(sentHash)) {
                    responseStatus = ResponseStatusEnum.RESEND;
                } else {
                    data = piece.getData();
                }
            } else {
                if (!(object instanceof Response)) throw new JmsFileTransferException("Unexpected message received: " + message);
                Response transferResp = (Response)object;
                if (transferResp.getStatus() != ResponseStatusEnum.STOPSEND) throw new JmsFileTransferException("Transfer aborted with status[" + (Object)((Object)transferResp.getStatus()) + "] from server");
                this.done = true;
            }
            final ResponseStatusEnum toSendStatus = responseStatus;
            this.support.getJmsTemplate().send(this.receiveAckDestination, new MessageCreator(){

                public Message createMessage(Session session) throws JMSException {
                    return DomainMessageUtils.toResponseMessage(session, new Response(toSendStatus));
                }
            });
            return data;
        }
        catch (JMSException e) {
            throw new JmsFileTransferException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new JmsFileTransferException(e);
        }
    }

    public void close() throws IOException {
        this.messageQueueListener.close();
        if (!this.done) {
            this.done = true;
            this.support.getJmsTemplate().send(this.receiveAckDestination, new MessageCreator(){

                public Message createMessage(Session session) throws JMSException {
                    return DomainMessageUtils.toResponseMessage(session, new Response(ResponseStatusEnum.DENY));
                }
            });
        }
        super.close();
    }

    protected void start() {
        this.support.getJmsTemplate().send(this.receiveAckDestination, new MessageCreator(){

            public Message createMessage(Session session) throws JMSException {
                Message responseMessage = DomainMessageUtils.toResponseMessage(session, new Response(ResponseStatusEnum.STARTSEND));
                responseMessage.setJMSReplyTo(JmsFileReceiverInputStream.this.support.factoryDestination(session, JmsFileReceiverInputStream.this.sendDataDestination));
                return responseMessage;
            }
        });
        this.started = true;
    }
}

