/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.mango.jms.connectionfac;

import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import org.calrissian.mango.jms.connectionfac.SelectorDestination;
import org.calrissian.mango.jms.connectionfac.SingleDestinationUtils;
import org.calrissian.mango.jms.connectionfac.decorator.MessageProducerDecorator;

class SingleDestinationMessageProducer
extends MessageProducerDecorator {
    private final Destination destination;
    private final SelectorDestination selectorDestination;

    public SingleDestinationMessageProducer(MessageProducer messageProducer, Destination destination, SelectorDestination selectorDestination) {
        super(messageProducer);
        this.destination = destination;
        this.selectorDestination = selectorDestination;
    }

    @Override
    public void send(Message message) throws JMSException {
        SingleDestinationUtils.preSendMessage(message, this.destination, (Destination)this.selectorDestination);
        super.send(message);
    }

    @Override
    public void send(Message message, int i, int i1, long l) throws JMSException {
        SingleDestinationUtils.preSendMessage(message, this.destination, (Destination)this.selectorDestination);
        super.send(message, i, i1, l);
    }

    @Override
    public void send(Destination destination, Message message) throws JMSException {
        if (destination == null) {
            throw new IllegalArgumentException("Destination cannot be null");
        }
        SingleDestinationUtils.preSendMessage(message, this.destination, destination);
        super.send(message);
    }

    @Override
    public void send(Destination destination, Message message, int i, int i1, long l) throws JMSException {
        if (destination == null) {
            throw new IllegalArgumentException("Destination cannot be null");
        }
        SingleDestinationUtils.preSendMessage(message, this.destination, destination);
        super.send(message, i, i1, l);
    }
}

