/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.mango.jms.connectionfac;

import java.util.UUID;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.Session;
import javax.jms.TemporaryQueue;
import org.calrissian.mango.jms.connectionfac.SelectorDestination;
import org.calrissian.mango.jms.connectionfac.SingleDestinationMessageConsumer;
import org.calrissian.mango.jms.connectionfac.SingleDestinationMessageProducer;
import org.calrissian.mango.jms.connectionfac.SingleDestinationUtils;
import org.calrissian.mango.jms.connectionfac.decorator.SessionDecorator;

class SingleQueueSession
extends SessionDecorator {
    private final Queue queue;

    public SingleQueueSession(Session session, String baseQueue) throws JMSException {
        super(session);
        this.queue = session.createQueue(baseQueue);
    }

    @Override
    public MessageProducer createProducer(Destination destination) throws JMSException {
        if (destination instanceof Queue) {
            return new SingleDestinationMessageProducer(super.createProducer((Destination)this.queue), (Destination)this.queue, SingleDestinationUtils.decorateDestination(destination));
        }
        return super.createProducer(destination);
    }

    @Override
    public MessageConsumer createConsumer(Destination destination) throws JMSException {
        if (destination instanceof Queue) {
            return new SingleDestinationMessageConsumer(super.createConsumer((Destination)this.queue, SingleDestinationUtils.generateSelector(SingleDestinationUtils.getDestination(destination), null)));
        }
        return super.createConsumer(destination);
    }

    @Override
    public MessageConsumer createConsumer(Destination destination, String selector) throws JMSException {
        if (destination instanceof Queue) {
            return new SingleDestinationMessageConsumer(super.createConsumer((Destination)this.queue, SingleDestinationUtils.generateSelector(SingleDestinationUtils.getDestination(destination), selector)));
        }
        return super.createConsumer(destination, selector);
    }

    @Override
    public MessageConsumer createConsumer(Destination destination, String selector, boolean noLocal) throws JMSException {
        if (destination instanceof Queue) {
            return new SingleDestinationMessageConsumer(super.createConsumer((Destination)this.queue, SingleDestinationUtils.generateSelector(SingleDestinationUtils.getDestination(destination), selector), noLocal));
        }
        return super.createConsumer(destination, selector, noLocal);
    }

    @Override
    public QueueBrowser createBrowser(Queue queue) throws JMSException {
        return super.createBrowser(queue, SingleDestinationUtils.generateSelector(this.queue.getQueueName(), null));
    }

    @Override
    public QueueBrowser createBrowser(Queue queue, String selector) throws JMSException {
        return super.createBrowser(queue, SingleDestinationUtils.generateSelector(this.queue.getQueueName(), selector));
    }

    @Override
    public TemporaryQueue createTemporaryQueue() throws JMSException {
        return new SelectorDestination(UUID.randomUUID().toString());
    }

    @Override
    public Queue createQueue(String name) throws JMSException {
        return new SelectorDestination(name);
    }
}

