/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.mango.jms.stream.utils;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Topic;
import org.calrissian.mango.jms.stream.AbstractJmsFileTransferSupport;
import org.calrissian.mango.jms.stream.JmsFileTransferException;
import org.springframework.jms.listener.SimpleMessageListenerContainer;

@Deprecated
public class MessageQueueListener
implements MessageListener {
    private BlockingQueue<Message> queueMessages = new LinkedBlockingQueue<Message>();
    private SimpleMessageListenerContainer messageListenerContainer;
    private AbstractJmsFileTransferSupport support;

    public MessageQueueListener(AbstractJmsFileTransferSupport support, String destination, boolean isTopic) {
        this.support = support;
        this.messageListenerContainer = new SimpleMessageListenerContainer();
        this.messageListenerContainer.setConnectionFactory(support.getJmsTemplate().getConnectionFactory());
        this.messageListenerContainer.setDestinationName(destination);
        this.messageListenerContainer.setMessageListener((Object)this);
        this.messageListenerContainer.setPubSubDomain(isTopic);
        this.messageListenerContainer.start();
    }

    public MessageQueueListener(AbstractJmsFileTransferSupport support, Destination destination) {
        this.support = support;
        this.messageListenerContainer = new SimpleMessageListenerContainer();
        this.messageListenerContainer.setConnectionFactory(support.getJmsTemplate().getConnectionFactory());
        this.messageListenerContainer.setDestination(destination);
        this.messageListenerContainer.setMessageListener((Object)this);
        this.messageListenerContainer.setPubSubDomain(destination instanceof Topic);
        this.messageListenerContainer.start();
    }

    public void close() {
        this.messageListenerContainer.stop();
    }

    public void onMessage(Message message) {
        try {
            this.queueMessages.put(message);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public Message getMessageInQueue() throws JmsFileTransferException {
        try {
            Message o = this.queueMessages.poll(this.support.getJmsTemplate().getReceiveTimeout(), TimeUnit.MILLISECONDS);
            if (o == null) {
                throw new JmsFileTransferException("Timeout reached in waiting for message");
            }
            return o;
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
    }
}

