/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.mango.jms.uri;

import java.net.URI;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageListener;
import org.calrissian.mango.jms.stream.JmsFileSenderListener;
import org.calrissian.mango.jms.stream.domain.Request;
import org.calrissian.mango.jms.stream.utils.DomainMessageUtils;
import org.calrissian.mango.uri.support.DataResolverFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class JmsUriSender
extends JmsFileSenderListener
implements MessageListener {
    public static Logger logger = LoggerFactory.getLogger(JmsUriSender.class);
    protected String systemName;

    public JmsUriSender(String systemName) {
        this.systemName = systemName;
    }

    @Override
    public void onMessage(Message request) {
        try {
            Request req = DomainMessageUtils.fromRequestMessage(request);
            URI uri = new URI(req.getDownloadUri());
            String systemNamePart = DataResolverFormatUtils.extractTargetSystemFromUri((URI)uri);
            if (systemNamePart.equals(this.systemName) || systemNamePart.equals("any")) {
                String requestUriPart = uri.toString().replaceFirst(uri.getScheme() + ":", "");
                logger.info("Honoring request with uri: " + requestUriPart);
                req = new Request(requestUriPart, req.getRequestId());
                this.getTaskExecutor().execute((Runnable)new JmsFileSenderRunnable(req, request.getJMSReplyTo()));
            } else {
                logger.info("Ignoring uri download request: " + uri);
            }
        }
        catch (Exception e1) {
            throw new RuntimeException(e1);
        }
    }

    private class JmsFileSenderRunnable
    implements Runnable {
        private Request req;
        private Destination jmsReplyTo;

        JmsFileSenderRunnable(Request req, Destination jmsReplyTo) {
            this.req = req;
            this.jmsReplyTo = jmsReplyTo;
        }

        @Override
        public void run() {
            try {
                JmsUriSender.this.sendStream(this.req, this.jmsReplyTo);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

