/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.mango.json.criteria;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import org.calrissian.mango.criteria.domain.AndNode;
import org.calrissian.mango.criteria.domain.EqualsLeaf;
import org.calrissian.mango.criteria.domain.Leaf;
import org.calrissian.mango.criteria.domain.Node;
import org.calrissian.mango.criteria.domain.NotEqualsLeaf;
import org.calrissian.mango.criteria.domain.OrNode;
import org.calrissian.mango.criteria.domain.ParentNode;
import org.calrissian.mango.criteria.domain.RangeLeaf;
import org.calrissian.mango.types.TypeRegistry;

public class NodeSerializer
extends JsonSerializer<Node> {
    private final TypeRegistry<String> typeRegistry;

    public NodeSerializer(TypeRegistry<String> typeRegistry) {
        this.typeRegistry = typeRegistry;
    }

    public void serialize(Node node, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        jsonGenerator.writeStartObject();
        if (node instanceof ParentNode) {
            this.serialize((ParentNode)node, jsonGenerator, serializerProvider);
        } else if (node instanceof Leaf) {
            this.serialize((Leaf)node, jsonGenerator, serializerProvider);
        } else {
            throw new IllegalArgumentException("Unsupported node: " + node);
        }
        jsonGenerator.writeEndObject();
    }

    public void serialize(ParentNode node, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        if (node instanceof AndNode) {
            jsonGenerator.writeObjectFieldStart("and");
        } else if (node instanceof OrNode) {
            jsonGenerator.writeObjectFieldStart("or");
        } else {
            throw new IllegalArgumentException("Unsupported parent: " + node);
        }
        jsonGenerator.writeArrayFieldStart("children");
        for (Node child : node.children()) {
            this.serialize(child, jsonGenerator, serializerProvider);
        }
        jsonGenerator.writeEndArray();
        jsonGenerator.writeEndObject();
    }

    public void serialize(Leaf node, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        if (node instanceof EqualsLeaf) {
            jsonGenerator.writeObjectFieldStart("eq");
            EqualsLeaf equalsLeaf = (EqualsLeaf)node;
            jsonGenerator.writeStringField("key", equalsLeaf.getKey());
            Object value = equalsLeaf.getValue();
            String type = this.typeRegistry.getAlias(value);
            String val_str = (String)this.typeRegistry.encode(value);
            jsonGenerator.writeStringField("type", type);
            jsonGenerator.writeStringField("value", val_str);
            jsonGenerator.writeEndObject();
        } else if (node instanceof NotEqualsLeaf) {
            NotEqualsLeaf leaf = (NotEqualsLeaf)node;
            jsonGenerator.writeObjectFieldStart("neq");
            jsonGenerator.writeStringField("key", leaf.getKey());
            Object value = leaf.getValue();
            String type = this.typeRegistry.getAlias(value);
            String val_str = (String)this.typeRegistry.encode(value);
            jsonGenerator.writeStringField("type", type);
            jsonGenerator.writeStringField("value", val_str);
            jsonGenerator.writeEndObject();
        } else if (node instanceof RangeLeaf) {
            RangeLeaf leaf = (RangeLeaf)node;
            jsonGenerator.writeObjectFieldStart("range");
            jsonGenerator.writeStringField("key", leaf.getKey());
            Object start = leaf.getStart();
            String type = this.typeRegistry.getAlias(start);
            String val_str = (String)this.typeRegistry.encode(start);
            jsonGenerator.writeStringField("type", type);
            jsonGenerator.writeStringField("start", val_str);
            Object end = leaf.getEnd();
            val_str = (String)this.typeRegistry.encode(end);
            jsonGenerator.writeStringField("end", val_str);
            jsonGenerator.writeEndObject();
        } else {
            throw new IllegalArgumentException("Unsupported leaf: " + node);
        }
    }
}

