/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.mango.json.uri.transform;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.net.MediaType;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.calrissian.mango.uri.domain.ResolvedItem;
import org.calrissian.mango.uri.exception.ContextTransformException;
import org.calrissian.mango.uri.transform.ContextTransformer;

public class JsonContextTransform
implements ContextTransformer<Object> {
    public static final MediaType CONTENT_TYPE = MediaType.JSON_UTF_8;
    private final ObjectMapper objectMapper;

    public JsonContextTransform(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public ResolvedItem transform(Object obj) throws ContextTransformException {
        try {
            byte[] json = this.objectMapper.writeValueAsBytes(obj);
            return new ResolvedItem(CONTENT_TYPE, null, (InputStream)new ByteArrayInputStream(json));
        }
        catch (IOException e) {
            throw new ContextTransformException((Throwable)e);
        }
    }

    public MediaType getMediaType(Object obj) throws ContextTransformException {
        return CONTENT_TYPE;
    }

    public String getContextName() {
        return "json";
    }
}

