/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.mango.json.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import org.calrissian.mango.domain.Tuple;
import org.calrissian.mango.domain.TupleStore;

public abstract class BaseTupleStoreDeserializer<T extends TupleStore>
extends JsonDeserializer<T> {
    private static final TypeReference TR = new TypeReference<Map<String, Collection<Tuple>>>(){};

    public T deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        JsonNode root = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
        T tupleStore = this.deserialize(root);
        ObjectNode tuplesObject = (ObjectNode)root.get("tuples");
        Map tuples = (Map)jsonParser.getCodec().readValue(jsonParser.getCodec().treeAsTokens((TreeNode)tuplesObject), TR);
        tupleStore.putAll(Iterables.concat(tuples.values()));
        return tupleStore;
    }

    public abstract T deserialize(JsonNode var1);
}

