/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.mango.json.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import org.calrissian.mango.domain.AbstractAttributeStoreBuilder;
import org.calrissian.mango.domain.Attribute;
import org.calrissian.mango.domain.AttributeStore;

abstract class AbstractAttributeStoreDeserializer<T extends AttributeStore, B extends AbstractAttributeStoreBuilder>
extends JsonDeserializer<T> {
    private static final TypeReference TR = new TypeReference<Map<String, Collection<Attribute>>>(){};

    AbstractAttributeStoreDeserializer() {
    }

    public T deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        JsonNode root = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
        B attributeStoreBuilder = this.deserialize(root);
        ObjectNode attributesObject = (ObjectNode)root.get("attributes");
        Map attributes = (Map)jsonParser.getCodec().readValue(jsonParser.getCodec().treeAsTokens((TreeNode)attributesObject), TR);
        for (Attribute attr : Iterables.concat(attributes.values())) {
            attributeStoreBuilder.attr(attr);
        }
        return this.build(attributeStoreBuilder);
    }

    public abstract B deserialize(JsonNode var1);

    public abstract T build(B var1);
}

