/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.mango.json.util.store;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.calrissian.mango.json.util.store.ArrayJsonNode;
import org.calrissian.mango.json.util.store.JsonTreeNode;
import org.calrissian.mango.json.util.store.ValueJsonNode;

class ObjectJsonNode
implements JsonTreeNode {
    private final Map<String, JsonTreeNode> children = new HashMap<String, JsonTreeNode>();
    private static final Maps.EntryTransformer<String, JsonTreeNode, Object> function = new Maps.EntryTransformer<String, JsonTreeNode, Object>(){

        public Object transformEntry(String s, JsonTreeNode jsonTreeNode) {
            return jsonTreeNode.toObject();
        }
    };

    ObjectJsonNode() {
    }

    @Override
    public void visit(String[] keys, int level, Map<Integer, Integer> levelToIdx, ValueJsonNode valueJsonNode) {
        if (level == keys.length - 1) {
            this.children.put(keys[level], valueJsonNode);
        } else {
            JsonTreeNode child = this.children.get(keys[level]);
            String nextKey = keys[level + 1];
            if (child == null) {
                child = nextKey.equals("[]") ? new ArrayJsonNode() : new ObjectJsonNode();
                this.children.put(keys[level], child);
            }
            child.visit(keys, level + 1, levelToIdx, valueJsonNode);
        }
    }

    @Override
    public Map<String, Object> toObject() {
        return Maps.transformEntries(this.children, function);
    }

    public String toString() {
        return this.toObject().toString();
    }
}

