/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.mango.json.util.store;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.DoubleNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.TextNode;

public class JsonUtil {
    private JsonUtil() {
    }

    static JsonNode objectToNode(Object obj) {
        if (obj instanceof Boolean) {
            return BooleanNode.valueOf((boolean)((Boolean)obj));
        }
        if (obj instanceof Integer) {
            return new IntNode(((Integer)obj).intValue());
        }
        if (obj instanceof Long) {
            return new LongNode(((Long)obj).longValue());
        }
        if (obj instanceof Double) {
            return new DoubleNode(((Double)obj).doubleValue());
        }
        if (obj instanceof Float) {
            return new DoubleNode(((Float)obj).doubleValue());
        }
        if (obj instanceof String) {
            return new TextNode((String)obj);
        }
        return null;
    }

    static Object nodeToObject(JsonNode jsonNode) {
        if (jsonNode.isBoolean()) {
            return jsonNode.asBoolean();
        }
        if (jsonNode.isDouble()) {
            return jsonNode.asDouble();
        }
        if (jsonNode.isLong()) {
            return jsonNode.asLong();
        }
        if (jsonNode.isInt()) {
            return jsonNode.asInt();
        }
        if (jsonNode.isTextual()) {
            return jsonNode.asText();
        }
        return null;
    }
}

