/*
 * Copyright (C) 2019 The Calrissian Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.calrissian.mango.json.mappings;

import java.util.Map;

import static com.google.common.base.Preconditions.checkNotNull;

/**
 * Json tree node representing a simple value leaf.
 */
class ValueJsonNode implements JsonTreeNode {

    private final Object value;

    public ValueJsonNode(Object value) {
        checkNotNull(value);
        this.value = value;
    }

    public Object getValue() {
        return value;
    }

    @Override
    public void visit(String[] keys, int level, Map<Integer, Integer> levelToIdx, ValueJsonNode valueJsonNode) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object toObject() {
        return value;
    }
}
