/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.mango.json.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.HashMap;
import org.calrissian.mango.domain.Attribute;
import org.calrissian.mango.types.TypeRegistry;

public class AttributeDeserializer
extends JsonDeserializer<Attribute> {
    private final TypeRegistry<String> typeRegistry;

    public AttributeDeserializer(TypeRegistry<String> typeRegistry) {
        this.typeRegistry = typeRegistry;
    }

    public Attribute deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        JsonNode root = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
        String key = root.get("key").asText();
        Object value = null;
        JsonNode type_json = root.get("type");
        if (type_json != null) {
            String type = type_json.asText();
            String val_str = root.get("value").asText();
            value = this.typeRegistry.decode(type, (Object)val_str);
        }
        HashMap<String, String> metadata = new HashMap<String, String>();
        JsonNode metadataArray = root.get("metadata");
        if (metadataArray != null) {
            for (JsonNode metadataItem : metadataArray) {
                String metaKey = metadataItem.get("key").asText();
                String normalized = metadataItem.get("value").asText();
                metadata.put(metaKey, normalized);
            }
        }
        return new Attribute(key, value, metadata);
    }
}

