/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.mango.json.mappings;

import com.google.common.collect.Collections2;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.calrissian.mango.json.mappings.JsonTreeNode;
import org.calrissian.mango.json.mappings.ObjectJsonNode;
import org.calrissian.mango.json.mappings.ValueJsonNode;

class ArrayJsonNode
implements JsonTreeNode {
    private final List<JsonTreeNode> children = new ArrayList<JsonTreeNode>();

    ArrayJsonNode() {
    }

    @Override
    public void visit(String[] keys, int level, Map<Integer, Integer> levelToIdx, ValueJsonNode valueJsonNode) {
        if (level == keys.length - 1) {
            this.children.add(valueJsonNode);
        } else {
            JsonTreeNode child = null;
            try {
                child = this.children.get(levelToIdx.get(level));
            }
            catch (Exception exception) {
                // empty catch block
            }
            String nextKey = keys[level + 1];
            if (child == null) {
                child = nextKey.equals("[]") ? new ArrayJsonNode() : new ObjectJsonNode();
                this.children.add(child);
            }
            child.visit(keys, level + 1, levelToIdx, valueJsonNode);
        }
    }

    @Override
    public Collection<Object> toObject() {
        return Collections2.transform(this.children, jsonTreeNode -> jsonTreeNode.toObject());
    }

    public String toString() {
        return this.toObject().toString();
    }
}

